function layout()
return {

modifiers = {
['LShift'] = 'LShift',
['RShift'] = 'RShift',
['LAlt'] = 'LAlt',
['RAlt'] = 'RAlt',
['LCtrl'] = 'LCtrl',
['RCtrl'] = 'RCtrl',
['LWin'] = 'LWin',
['RWin'] = 'RWin',
},

keyCommands = {

-- Temporary
{combos = {{key = 'X', reformers = {'LShift', 'LCtrl'}}}, down = iCommandViewExplosion, name = 'Explosion', category = 'Cheat'},

{combos = {{key = 'Home', reformers = {'RWin'}}} , 	down = iCommandEnginesStart, name = 'Start Procedure', category = 'Cheat'},
{combos = {{key = 'End', reformers = {'RWin'}}} , 	down = iCommandEnginesStop, name = 'Stop Procedure', category = 'Cheat'},

-- Gameplay
{combos = {{key = '`'}}, down = ICommandToggleConsole, name = 'Toggle Console', category = 'General'},
{combos = {{key = 'Pause', reformers = {'LShift', 'LWin'}}}, down = iCommandActivePauseOnOff, name = 'Active Pause', category = 'Cheat'},
{combos = {{key = 'Esc'}}, 									down = iCommandQuit, name = 'End mission', category = 'General'},
{combos = {{key = 'Pause'}}, 								down = iCommandBrakeGo, name = 'Pause', category = 'General'},
{combos = {{key = 'Z', reformers = {'LCtrl'}}}, 			down = iCommandAccelerate, name = 'Time accelerate', category = 'General'},
{combos = {{key = 'Z', reformers = {'LAlt'}}}, 				down = iCommandDecelerate, name = 'Time decelerate', category = 'General'},
{combos = {{key = 'Z', reformers = {'LShift'}}}, 			down = iCommandNoAcceleration, name = 'Time normal', category = 'General'},
{combos = {{key = '\''}}, 									down = iCommandScoresWindowToggle, name = 'Score window', category = 'General'},
{combos = {{key = 'Tab'}}, 									down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{combos = {{key = 'Tab', reformers = {'RCtrl'}}}, 			down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{combos = {{key = 'Y', reformers = {'LCtrl'}}}, 			down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
{combos = {{key = 'Tab', reformers = {'RCtrl', 'RShift'}}}, down = iCommandRecoverHuman, name = 'Get new plane - respawn', category = 'General'},
{combos = {{key = 'SysRQ'}}, 								down = iCommandScreenShot, name = 'Screenshot', category = 'General'},
{combos = {{key = 'Tab', reformers = {'LShift'}}}, 			down = iCommandTrkEsc, name = 'Playback track cancel', category = 'General'},
{combos = {{key = 'Y', reformers = {'LShift'}}}, 			down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
{combos = {{key = 'Pause', reformers = {'RShift'}}},		down = iCommandOneFrame, name = 'One frame mode', category = 'General'},
{combos = {{key = 'Pause', reformers = {'RCtrl'}}}, 		down = iCommandGraphicsFrameRate, name = 'Frame rate counter - Service info', category = 'General'},
{combos = {{key = 'Y', reformers = {'LAlt'}}}, 				down = iCommandViewCoordinatesInLinearUnits, name = 'Coordinates units change', category = 'General'},
{combos = {{key = 'M', reformers = {'RCtrl'}}}, 			down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{combos = {{key = 'M', reformers = {'RAlt'}}}, 				down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{combos = {{key = 'C', reformers = {'LAlt'}}}, 				down = iCommandCockpitClickModeOnOff, name = 'Clickable mouse cockpit mode On/Off', category = 'General'},
{combos = {{key = 'Enter', reformers = {'RCtrl'}}}, 		down = iCommandPlane_ShowControls, name = 'Show controls indicator' , category = 'General'},

-- Sensors
--{combos = {{key = 'R', reformers = {'RShift'}}}, down = iCommandChangeRWRMode, name = 'Change RWR/SPO Mode', category = 'Sensors'},
--{combos = {{key = ',', reformers = {'RAlt'}}}  , down = iCommandPlaneThreatWarnSoundVolumeDown, name = 'RWR/SPO Sound Signals Volume Down', category = 'Sensors'},
--{combos = {{key = '.', reformers = {'RAlt'}}}  , down = iCommandPlaneThreatWarnSoundVolumeUp, name = 'RWR/SPO Sound Signals Volume Up', category = 'Sensors'},

-- Communications
{combos = {{key = 'E', reformers = {'LWin'}}}, 	down = iCommandPlaneDoAndHome, name = 'Dispatch wingmans - complete mission and RTB', category = 'Communications'},
{combos = {{key = 'R', reformers = {'LWin'}}}, 	down = iCommandPlaneDoAndBack, name = 'Dispatch wingmans - complete mission and rejoin', category = 'Communications'},
{combos = {{key = 'T', reformers = {'LWin'}}}, 	down = iCommandPlaneFormation, name = 'Toggle formation', category = 'Communications'},
{combos = {{key = 'Y', reformers = {'LWin'}}}, 	down = iCommandPlaneJoinUp, name = 'Join up formation', category = 'Communications'},
{combos = {{key = 'Q', reformers = {'LWin'}}}, 	down = iCommandPlaneAttackMyTarget, name = 'Attack my target', category = 'Communications'},
{combos = {{key = 'W', reformers = {'LWin'}}}, 	down = iCommandPlaneCoverMySix, name = 'Cover me', category = 'Communications'},
{combos = {{key = 'U', reformers = {'LWin'}}}, 	down = iCommandAWACSHomeBearing, name = 'Ask AWACS home airbase', category = 'Communications'},
{combos = {{key = 'I', reformers = {'LWin'}}}, 	down = iCommandAWACSTankerBearing, name = 'Ask AWACS available tanker', category = 'Communications'},
{combos = {{key = 'G', reformers = {'LWin'}}}, 	down = iCommandPlane_EngageGroundTargets, name = 'Attack Ground Targets', category = 'Communications'},
{combos = {{key = 'D', reformers = {'LWin'}}}, 	down = iCommandPlane_EngageAirDefenses, name = 'Attack Air Defenses', category = 'Communications'},
{combos = {{key = '\\'}}, 						down = iCommandToggleCommandMenu, name = 'Communication menu', category = 'Communications'},
{combos = {{key = '\\', reformers = {'LShift'}}}, down = ICommandSwitchDialog, name = 'Switch dialog', category = 'Communications'},

-- View                                                    
{combos = {{key = 'Num4'}}, pressed = iCommandViewLeftSlow, up = iCommandViewStopSlow, name = 'View Left slow', category = 'View'},
{combos = {{key = 'Num6'}}, pressed = iCommandViewRightSlow, up = iCommandViewStopSlow, name = 'View Right slow', category = 'View'},
{combos = {{key = 'Num8'}}, pressed = iCommandViewUpSlow, up = iCommandViewStopSlow, name = 'View Up slow', category = 'View'},
{combos = {{key = 'Num2'}}, pressed = iCommandViewDownSlow, up = iCommandViewStopSlow, name = 'View Down slow', category = 'View'},
{combos = {{key = 'Num9'}}, pressed = iCommandViewUpRightSlow, up = iCommandViewStopSlow, name = 'View Up Right slow', category = 'View'},
{combos = {{key = 'Num3'}}, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = 'View Down Right slow', category = 'View'},
{combos = {{key = 'Num1'}}, pressed = iCommandViewDownLeftSlow, up = iCommandViewStopSlow, name = 'View Down Left slow', category = 'View'},
{combos = {{key = 'Num7'}}, pressed = iCommandViewUpLeftSlow, up = iCommandViewStopSlow, name = 'View Up Left slow', category = 'View'},
{combos = {{key = 'Num5'}}, pressed = iCommandViewCenter, name = 'View Center', category = 'View'},

{combos = {{key = 'Num*'}}, 							pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = 'Zoom in slow', category = 'View'},
{combos = {{key = 'Num/'}}, 							pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = 'Zoom out slow', category = 'View'},
{combos = {{key = 'NumEnter'}}, 						down = iCommandViewAngleDefault, name = 'Zoom normal', category = 'View'},
{combos = {{key = 'Num*', reformers = {'RCtrl'}}}, 		pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = 'Zoom external in', category = 'View'},
{combos = {{key = 'Num/', reformers = {'RCtrl'}}}, 		pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = 'Zoom external out', category = 'View'},
{combos = {{key = 'NumEnter', reformers = {'RCtrl'}}}, 	down = iCommandViewExternalZoomDefault, name = 'Zoom external normal', category = 'View'},
{combos = {{key = 'Num*', reformers = {'LAlt'}}}, 		down = iCommandViewSpeedUp, name = 'F11 camera moving forward', category = 'View'},
{combos = {{key = 'Num/', reformers = {'LAlt'}}}, 		down = iCommandViewSlowDown, name = 'F11 camera moving backward', category = 'View'},


{combos = {{key = 'F1'}}, 							down = iCommandViewCockpit, name = 'F1 Cockpit view', category = 'View'},
{combos = {{key = 'F1', reformers = {'LCtrl'}}}, 	down = iCommandNaturalViewCockpitIn, name = 'F1 Natural head movement view', category = 'View'},
{combos = {{key = 'F1', reformers = {'LAlt'}}}, 	down = iCommandViewHUDOnlyOnOff, name = 'F1 HUD only view switch', category = 'View'},
{combos = {{key = 'F2'}}, 							down = iCommandViewAir, name = 'F2 Aircraft view', category = 'View'},
{combos = {{key = 'F2', reformers = {'LCtrl'}}}, 	down = iCommandViewMe, name = 'F2 View own aircraft', category = 'View'},
{combos = {{key = 'F2', reformers = {'RAlt'}}}, 	down = iCommandViewFromTo, name = 'F2 Toggle camera position', category = 'View'},
{combos = {{key = 'F2', reformers = {'LAlt'}}}, 	down = iCommandViewLocal, name = 'F2 Toggle local camera control', category = 'View'},
{combos = {{key = 'F3'}}, 							down = iCommandViewTower, name = 'F3 Fly-By view', category = 'View'},
{combos = {{key = 'F3', reformers = {'LCtrl'}}}, 	down = iCommandViewTowerJump, name = 'F3 Fly-By jump view', category = 'View'},
{combos = {{key = 'F4'}}, 							down = iCommandViewChaseArcade, name = 'F4 Arcade View', category = 'View'},
{combos = {{key = 'F4', reformers = {'LShift'}}}, 	down = iCommandViewRear, name = 'F4 Look back view', category = 'View'},
{combos = {{key = 'F4', reformers = {'LCtrl'}}}, 	down = iCommandViewChase, name = 'F4 Chase view', category = 'View'},
{combos = {{key = 'F5'}}, 							down = iCommandViewFight, name = 'F5 nearest AC view', category = 'View'},
{combos = {{key = 'F5', reformers = {'LCtrl'}}}, 	down = iCommandViewFightGround, name = 'F5 Ground hostile view', category = 'View'},
{combos = {{key = 'F6'}}, 							down = iCommandViewWeapons, name = 'F6 Released weapon view', category = 'View'},
{combos = {{key = 'F6', reformers = {'LCtrl'}}}, 	down = iCommandViewWeaponAndTarget, name = 'F6 Weapon to target view', category = 'View'},
{combos = {{key = 'F7'}}, 							down = iCommandViewGround, name = 'F7 Ground unit view', category = 'View'},
{combos = {{key = 'F7', reformers = {'LCtrl'}}},    down = iCommandViewJFO, name = 'F7 Ground JFO/JTAC view', category = 'View'},
--{combos = {{key = 'F8'}}, 							down = iCommandViewTargets, name = 'F8 Target view', category = 'View'},
--{combos = {{key = 'F8', reformers = {'RAlt'}}}, 	down = iCommandViewTargetType, name = 'F8 Player targets/All targets filter', category = 'View'},
{combos = {{key = 'F9'}}, 							down = iCommandViewNavy, name = 'F9 Ship view', category = 'View'},
{combos = {{key = 'F9', reformers = {'LAlt'}}}, 	down = iCommandViewLndgOfficer, name = 'F9 Landing signal officer view', category = 'View'},
{combos = {{key = 'F10'}}, 							down = iCommandViewAWACS, name = 'F10 Theater map view', category = 'View'},
{combos = {{key = 'F10', reformers = {'LCtrl'}}}, 	down = iCommandViewAWACSJump, name = 'F10 Jump to theater map view over current point', category = 'View'},
{combos = {{key = 'F11'}}, 							down = iCommandViewFree, name = 'F11 Airport free camera', category = 'View'},
{combos = {{key = 'F11', reformers = {'LCtrl'}}}, 	down = iCommandViewFreeJump, name = 'F11 Jump to free camera', category = 'View'},
{combos = {{key = 'F12'}}, 							down = iCommandViewStatic, name = 'F12 Static object view', category = 'View'},
{combos = {{key = 'F12', reformers = {'LCtrl'}}}, 	down = iCommandViewMirage, name = 'F12 Civil traffic view', category = 'View'},
{combos = {{key = 'F12', reformers = {'LShift'}}}, 	down = iCommandViewLocomotivesToggle, name = 'F12 Trains/cars toggle', category = 'View'},
{combos = {{key = 'F1', reformers = {'LWin'}}} , 	down = iCommandViewPitHeadOnOff, name = 'F1 Head shift movement on / off', category = 'View'},

{combos = {{key = ']', reformers = {'LShift'}}}, 	down = iCommandViewFastKeyboard, name = 'Fast keyboard turn speed', category = 'View'},
{combos = {{key = ']', reformers = {'LCtrl'}}}, 	down = iCommandViewSlowKeyboard, name = 'Slow keyboard turn speed', category = 'View'},
{combos = {{key = ']', reformers = {'LAlt'}}}, 		down = iCommandViewNormalKeyboard, name = 'Normal keyboard turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LShift'}}}, 	down =  iCommandViewFastMouse, name = 'Fast mouse turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LCtrl'}}}, 	down = iCommandViewSlowMouse, name = 'Slow mouse turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LAlt'}}}, 		down = iCommandViewNormalMouse, name = 'Normal mouse turn speed', category = 'View'},


-- Cockpit view
{combos = {{key = 'Num0'}}, 						down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = 'Cockpit panel view in', category = 'View Cockpit'},
{combos = {{key = 'Num0', reformers = {'RCtrl'}}}, 	down = iCommandViewTempCockpitToggle, name = 'Cockpit panel view toggle', category = 'View Cockpit'},
{combos = {{key = 'Num0', reformers = {'RAlt'}}}, 	down = iCommandViewSaveAngles, name = 'Save Cockpit Angles', category = 'View Cockpit'}, -- Save current cockpit camera angles for fast numpad jumps  
{combos = {{key = 'Num8', reformers = {'RShift'}}}, pressed = iCommandViewUp, up = iCommandViewStop, name = 'View up', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RShift'}}}, pressed = iCommandViewDown, up = iCommandViewStop, name = 'View down', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RShift'}}}, pressed = iCommandViewLeft, up = iCommandViewStop, name = 'View left', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RShift'}}}, pressed = iCommandViewRight, up = iCommandViewStop, name = 'View right', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RShift'}}}, pressed = iCommandViewUpRight, up = iCommandViewStop, name = 'View up right', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RShift'}}}, pressed = iCommandViewDownRight, up = iCommandViewStop, name = 'View down right', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RShift'}}}, pressed = iCommandViewDownLeft, up = iCommandViewStop, name = 'View down left', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RShift'}}}, pressed = iCommandViewUpLeft, up = iCommandViewStop, name = 'View up left', category = 'View Cockpit'},

{combos = {{key = 'Num8', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = 'Camera view up', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = 'Camera view down', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = 'Camera view left', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = 'Camera view right', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = 'Camera view up-left', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = 'Camera view down-left', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = 'Camera view up-right', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = 'Camera view down-right', category = 'View Cockpit'},

{combos = {{key = 'Num8', reformers = {'RAlt'}}}, 	down = iCommandViewCameraUpSlow, name = 'Camera view up slow', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RAlt'}}}, 	down = iCommandViewCameraDownSlow, name = 'Camera view down slow', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RAlt'}}}, 	down = iCommandViewCameraLeftSlow, name = 'Camera view left slow', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RAlt'}}}, 	down = iCommandViewCameraRightSlow, name = 'Camera view right slow', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RAlt'}}}, 	down = iCommandViewCameraUpLeftSlow, name = 'Camera view up-left slow', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RAlt'}}}, 	down = iCommandViewCameraDownLeftSlow, name = 'Camera view down-left slow', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RAlt'}}}, 	down = iCommandViewCameraDownRight, name = 'Camera view up-right slow', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RAlt'}}}, 	down = iCommandViewCameraUpRightSlow, name = 'Camera view down-right slow', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RShift'}}}, down = iCommandViewCameraCenter, name = 'Center camera view', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraReturn, name = 'Return camera', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RAlt'}}}, 	down = iCommandViewCameraBaseReturn, name = 'Return camera base', category = 'View Cockpit'},

{combos = {{key = 'Num0', reformers = {'LWin'}}}, down = iCommandViewSnapView0,	up = iCommandViewSnapViewStop, name = 'Snap View 0', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'LWin'}}}, down = iCommandViewSnapView1,	up = iCommandViewSnapViewStop, name = 'Snap View 1', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'LWin'}}}, down = iCommandViewSnapView2,	up = iCommandViewSnapViewStop, name = 'Snap View 2', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'LWin'}}}, down = iCommandViewSnapView3,	up = iCommandViewSnapViewStop, name = 'Snap View 3', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'LWin'}}}, down = iCommandViewSnapView4,	up = iCommandViewSnapViewStop, name = 'Snap View 4', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'LWin'}}}, down = iCommandViewSnapView5,	up = iCommandViewSnapViewStop, name = 'Snap View 5', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'LWin'}}}, down = iCommandViewSnapView6,	up = iCommandViewSnapViewStop, name = 'Snap View 6', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'LWin'}}}, down = iCommandViewSnapView7,	up = iCommandViewSnapViewStop, name = 'Snap View 7', category = 'View Cockpit'},
{combos = {{key = 'Num8', reformers = {'LWin'}}}, down = iCommandViewSnapView8,	up = iCommandViewSnapViewStop, name = 'Snap View 8', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'LWin'}}}, down = iCommandViewSnapView9,	up = iCommandViewSnapViewStop, name = 'Snap View 9', category = 'View Cockpit'},

{combos = {{key = 'N', reformers = {'RWin'}}}, down = iCommandViewLeftMirrorOn ,	up = iCommandViewLeftMirrorOff , name = 'Left Mirror On', category = 'View Cockpit'},
{combos = {{key = 'M', reformers = {'RWin'}}}, down = iCommandViewRightMirrorOn,	up = iCommandViewRightMirrorOff, name = 'Right Mirror On', category = 'View Cockpit'},

{combos = {{key = 'Num*', reformers = {'RShift'}}}, pressed = iCommandViewForward, up = iCommandViewForwardStop, name = 'Zoom in', category = 'View Cockpit'},
{combos = {{key = 'Num/', reformers = {'RShift'}}}, pressed = iCommandViewBack, up = iCommandViewBackStop, name = 'Zoom out', category = 'View Cockpit'},

-- Cockpit Camera Motion (   )
{combos = {{key = 'Num8', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveUp, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Up', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveDown, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Down', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveLeft, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Left', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveRight, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Right', category = 'View Cockpit'},
{combos = {{key = 'Num*', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveForward, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Forward', category = 'View Cockpit'},
{combos = {{key = 'Num/', reformers = {'RCtrl','RShift'}}, {key = 'Num-', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveBack, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Back', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RCtrl','RShift'}}}, down = iCommandViewPitCameraMoveCenter, name = 'Cockpit Camera Move Center', category = 'View Cockpit'},

-- Extended view
{combos = {{key = 'J', reformers = {'LShift'}}}, 			down = iCommandViewCameraJiggle, name = 'Camera jiggle toggle', category = 'View Extended'},
{combos = {{key = 'K', reformers = {'LAlt'}}}, 				down = iCommandViewKeepTerrain, name = 'Keep terrain camera altitude', category = 'View Extended'},
{combos = {{key = 'Home', reformers = {'RCtrl','RShift'}}}, down = iCommandViewFriends, name = 'View friends mode', category = 'View Extended'},
{combos = {{key = 'End', reformers = {'RCtrl' ,'RShift'}}}, down = iCommandViewEnemies, name = 'View enemies mode', category = 'View Extended'},
{combos = {{key = 'Delete', reformers = {'RCtrl'}}}, 		down = iCommandViewAll, name = 'View all mode', category = 'View Extended'},
{combos = {{key = 'Num+', reformers = {'RShift'}}}, 			down = iCommandViewPlus, name = 'Toggle tracking fire weapon', category = 'View Extended'},
{combos = {{key = 'PageDown', reformers = {'LCtrl'}}}, 		down = iCommandViewSwitchForward, name = 'Objects switching direction forward ', category = 'View Extended'},
{combos = {{key = 'PageUp', reformers = {'LCtrl'}}}, 		down = iCommandViewSwitchReverse, name = 'Objects switching direction reverse ', category = 'View Extended'},
{combos = {{key = 'Delete', reformers = {'LAlt'}}}, 		down = iCommandViewObjectIgnore, name = 'Object exclude ', category = 'View Extended'},
{combos = {{key = 'Insert', reformers = {'LAlt'}}}, 		down = iCommandViewObjectsAll, name = 'Objects all excluded - include', category = 'View Extended'},

-- Padlock

{combos = {{key = 'Num.', reformers = {'RShift'}}}, down = iCommandAllMissilePadlock, name = 'All missiles padlock', category = 'View Padlock'},
{combos = {{key = 'Num.', reformers = {'RAlt'}}}, down = iCommandThreatMissilePadlock, name = 'Threat missile padlock', category = 'View Padlock'},
{combos = {{key = 'Num.'}}, 						down = iCommandViewLock, name = 'Lock view (cycle padlock)', category = 'View Padlock'},
{combos = {{key = 'NumLock'}}, 						down = iCommandViewUnlock, name = 'Unlock view (stop padlock)', category = 'View Padlock'},
{combos = {{key = 'Num.', reformers = {'RCtrl'}}}, 	down = iCommandViewTerrainLock, name = 'Lock terrain view', category = 'View Padlock'},


-- Labels
{combos = {{key = 'F10', reformers = {'LShift'}}}, 	down = iCommandMarkerState, name = 'All Labels', category = 'Labels'},
{combos = {{key = 'F2', reformers = {'LShift'}}}, 	down = iCommandMarkerStatePlane, name = 'Aircraft Labels', category = 'Labels'},
{combos = {{key = 'F6', reformers = {'LShift'}}}, 	down = iCommandMarkerStateRocket, name = 'Missile Labels', category = 'Labels'},
{combos = {{key = 'F9', reformers = {'LShift'}}}, 	down = iCommandMarkerStateShip, name = 'Vehicle & Ship Labels', category = 'Labels'},

-- HOTAS
{combos = {{key = 'Space', reformers = {'RAlt'}}}, 	down = iCommandPlanePickleOn, up = iCommandPlanePickleOff, name = 'Weapon release', category = 'HOTAS'},
{combos = {{key = 'Space'}}, 	down = iCommandPlane_HOTAS_TriggerSecondStage, up = iCommandPlane_HOTAS_TriggerSecondStage_Off, name = 'Gun Trigger', category = 'HOTAS'},
{combos = {{key = 'P'}},		down = iCommandPlane_HOTAS_TriggerFirstStage , up = iCommandPlane_HOTAS_TriggerFirstStage_Off, name = 'Gun Trigger (first stage)', category = 'HOTAS'},

{combos = {{key = 'Home'}}, 	down = iCommandPlane_HOTAS_DataManagementSwitchUp,    up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Forward',    category = 'HOTAS'},
{combos = {{key = 'End'}}, 		down = iCommandPlane_HOTAS_DataManagementSwitchDown,  up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Aft',  category = 'HOTAS'},
{combos = {{key = 'Delete'}}, 	down = iCommandPlane_HOTAS_DataManagementSwitchLeft,  up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Left',  category = 'HOTAS'},
{combos = {{key = 'PageDown'}}, down = iCommandPlane_HOTAS_DataManagementSwitchRight, up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Right', category = 'HOTAS'},

{combos = {{key = 'Up',		reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchUp,    up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Forward',    category = 'HOTAS'},
{combos = {{key = 'Down',	reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchDown,  up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Aft',  category = 'HOTAS'},
{combos = {{key = 'Left',	reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchLeft,  up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Left',  category = 'HOTAS'},
{combos = {{key = 'Right',	reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchRight, up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Right', category = 'HOTAS'},

{combos = {{key = '7'}}, 		down = iCommandPlane_HOTAS_CMS_Up   , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Forward', category = 'HOTAS'},
{combos = {{key = '8'}}, 		down = iCommandPlane_HOTAS_CMS_Down , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Aft',  category = 'HOTAS'},
{combos = {{key = '9'}}, 		down = iCommandPlane_HOTAS_CMS_Left , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Left',  category = 'HOTAS'},
{combos = {{key = '0'}}, 		down = iCommandPlane_HOTAS_CMS_Right, up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Right', category = 'HOTAS'},
{combos = {{key = '-'}}, 		down = iCommandPlane_HOTAS_CMS_Zaxis, up = iCommandPlane_HOTAS_CMS_Zaxis_Off, name = 'HOTAS CMS Z Axis', category = 'HOTAS'},

{combos = {{key = ';'}}, 		pressed = iCommandPlaneRadarUp, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Up', category = 'HOTAS'},
{combos = {{key = '.'}}, 		pressed = iCommandPlaneRadarDown, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Down', category = 'HOTAS'},
{combos = {{key = ','}}, 		pressed = iCommandPlaneRadarLeft, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Left', category = 'HOTAS'},
{combos = {{key = '/'}}, 		pressed = iCommandPlaneRadarRight, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Right', category = 'HOTAS'},

{combos = {{key = 'U'}}, 		down = iCommandPlane_HOTAS_CoolieUp,    up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Up',    category = 'HOTAS'},
{combos = {{key = 'J'}}, 		down = iCommandPlane_HOTAS_CoolieDown,  up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Down',  category = 'HOTAS'},
{combos = {{key = 'H'}}, 		down = iCommandPlane_HOTAS_CoolieLeft,  up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Left',  category = 'HOTAS'},
{combos = {{key = 'K'}}, 		down = iCommandPlane_HOTAS_CoolieRight, up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Right', category = 'HOTAS'},

{combos = {{key = 'Left',	reformers = {'RAlt'}}},	down = iCommandPlane_HOTAS_BoatSwitchAft, name = 'HOTAS Boat Switch Aft', category = 'HOTAS'},
{combos = {{key = 'Down',	reformers = {'RAlt'}}},	down = iCommandPlane_HOTAS_BoatSwitchCenter, name = 'HOTAS Boat Switch Center', category = 'HOTAS'},
{combos = {{key = 'Right',	reformers = {'RAlt'}}},	down = iCommandPlane_HOTAS_BoatSwitchForward, name = 'HOTAS Boat Switch Forward', category = 'HOTAS'},

{combos = {{key = 'C'}}, 		down = iCommandPlane_HOTAS_ChinaHatAft, up = iCommandPlane_HOTAS_ChinaHatOff, name = 'HOTAS China Hat Aft', category = 'HOTAS'},
{combos = {{key = 'V'}}, 		down = iCommandPlane_HOTAS_ChinaHatForward, up = iCommandPlane_HOTAS_ChinaHatOff, name = 'HOTAS China Hat Forward', category = 'HOTAS'},

{combos = {{key = 'Q'}}, 		down = iCommandPlane_HOTAS_LeftThrottleButton, name = 'HOTAS Left Throttle Button', category = 'HOTAS'},
{combos = {{key = 'M'}}, 		down = iCommandPlane_HOTAS_MasterModeControlButton, up = iCommandPlane_HOTAS_MasterModeControlButtonUP, name = 'HOTAS Master Mode Control Button', category = 'HOTAS'},
{combos = {{key = 'Insert'}}, 	down = iCommandPlane_HOTAS_NoseWheelSteeringButton, up = iCommandPlane_HOTAS_NoseWheelSteeringButtonOff, name = 'HOTAS Nosewheel Steering Button', category = 'HOTAS'},

{combos = {{key = 'B', reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_SpeedBrakeSwitchAft, up = iCommandPlane_HOTAS_SpeedBrakeSwitchCenter, name = 'HOTAS Speed Brake Switch Aft', category = 'HOTAS'},
{combos = {{key = 'B', reformers = {'LShift'}}}, 	down = iCommandPlane_HOTAS_SpeedBrakeSwitchForward, up = iCommandPlane_HOTAS_SpeedBrakeSwitchCenter, name = 'HOTAS Speed Brake Switch Forward', category = 'HOTAS'},

{combos = {{key = 'P', reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_PinkySwitchAft,     name = 'HOTAS Pinky Switch Aft',     category = 'HOTAS'},
{combos = {{key = 'P', reformers = {'LAlt'}}}, 		down = iCommandPlane_HOTAS_PinkySwitchForward, name = 'HOTAS Pinky Switch Forward', category = 'HOTAS'},
{combos = {{key = 'P', reformers = {'LShift'}}}, 	down = iCommandPlane_HOTAS_PinkySwitchCenter,  name = 'HOTAS Pinky Switch Center',  category = 'HOTAS'},

{combos = {{key = 'Num+', reformers = {'LShift'}}}, down = iCommandPlane_HOTAS_MIC_SwitchUp,    up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Up',    category = 'HOTAS'},
{combos = {{key = 'Num-', reformers = {'LAlt'}}}, 	down = iCommandPlane_HOTAS_MIC_SwitchDown,  up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Down',  category = 'HOTAS'},
{combos = {{key = 'Num-', reformers = {'LShift'}}}, down = iCommandPlane_HOTAS_MIC_SwitchLeft,  up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Aft',  category = 'HOTAS'},
{combos = {{key = 'Num+', reformers = {'LAlt'}}}, 	down = iCommandPlane_HOTAS_MIC_SwitchRight, up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Forward', category = 'HOTAS'},

{combos = {{key = ';', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = 'Trim: Nose Down', category = 'HOTAS'},
{combos = {{key = '.', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = 'Trim: Nose Up', category = 'HOTAS'},
{combos = {{key = ',', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = 'Trim: Left Wing Down', category = 'HOTAS'},
{combos = {{key = '/', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = 'Trim: Right Wing Down', category = 'HOTAS'},
{combos = {{key = 'T', reformers = {'LCtrl'}}}, down = iCommandPlaneTrimCancel, name = 'Trim: Reset', category = 'HOTAS'},

{combos = {{key = 'E', reformers = {'LAlt'}}} , down = iCommandPlaneEmergencyDisconnectLever, up = iCommandPlaneEmergencyDisconnectLever, name = 'Emergency Disconnect Lever', category = 'HOTAS'},

-- Flight Control
{combos = {{key = 'Up'}},						down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = 'Fly: Nose Down', category = 'Flight Control'},
{combos = {{key = 'Down'}},						down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = 'Fly: Nose Up', category = 'Flight Control'},
{combos = {{key = 'Left'}},						down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = 'Fly: Left Wing Down', category = 'Flight Control'},
{combos = {{key = 'Right'}},					down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = 'Fly: Right Wing Down', category = 'Flight Control'},
{combos = {{key = 'Z'}},						down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = 'Fly: Rudder Left', category = 'Flight Control'},
{combos = {{key = 'X'}},						down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = 'Fly: Rudder Right', category = 'Flight Control'},

{combos = {{key = 'Num+'}},								  down = iCommandThrottleIncrease,	up = iCommandThrottleStop,	name = 'Throttle Both Up', category = 'Flight Control'},
{combos = {{key = 'Num-'}},								  down = iCommandThrottleDecrease,	up = iCommandThrottleStop,	name = 'Throttle Both Down', category = 'Flight Control'},
{combos = {{key = 'Num+'	, reformers = {'RAlt'}}}	, down = iCommandThrottle1Increase,	up = iCommandThrottle1Stop,	name = 'Throttle Left Up', category = 'Flight Control'},
{combos = {{key = 'Num-'	, reformers = {'RAlt'}}}	, down = iCommandThrottle1Decrease,	up = iCommandThrottle1Stop,	name = 'Throttle Left Down', category = 'Flight Control'},
{combos = {{key = 'Num+'	, reformers = {'RCtrl'}}}	, down = iCommandThrottle2Increase,	up = iCommandThrottle2Stop,	name = 'Throttle Right Up', category = 'Flight Control'},
{combos = {{key = 'Num-'	, reformers = {'RCtrl'}}}	, down = iCommandThrottle2Decrease,	up = iCommandThrottle2Stop,	name = 'Throttle Right Down', category = 'Flight Control'},
{combos = {{key = 'PageUp'  , reformers = {'RAlt'}}}	, down = iCommandPlaneAUTIncreaseRegimeLeft,					name = 'Throttle Left Up Step', category = 'Flight Control'},
{combos = {{key = 'PageDown', reformers = {'RAlt'}}}	, down = iCommandPlaneAUTDecreaseRegimeLeft,					name = 'Throttle Left Down Step', category = 'Flight Control'},
{combos = {{key = 'PageUp'  , reformers = {'RCtrl'}}}	, down = iCommandPlaneAUTIncreaseRegimeRight,					name = 'Throttle Right Up Step', category = 'Flight Control'},
{combos = {{key = 'PageDown', reformers = {'RCtrl'}}}	, down = iCommandPlaneAUTDecreaseRegimeRight,					name = 'Throttle Right Down Step', category = 'Flight Control'},

-- {combos = {{key = 'F'}},					 		down = iCommandPlaneFlaps   , name = 'Toggle Flaps Up/Down', category = 'Systems'},
{combos = {{key = 'F'}}, 							down = iCommandPlaneFlapsOn , name = 'Flaps Down', category = 'Systems'},
{combos = {{key = 'F', reformers = {'LShift'}}} , 	down = iCommandPlaneFlapsOff, name = 'Flaps Up', category = 'Systems'},
{combos = {{key = 'W'}}, 							down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = 'Wheel Brake On/Off', category = 'Systems'},
{combos = {{key = 'W', reformers = {'LShift'}}}, 	down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, name = 'Wheel Brake Left On/Off', category = 'Systems'},
{combos = {{key = 'W', reformers = {'LAlt'}}}, 		down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = 'Wheel Brake Right On/Off', category = 'Systems'},
{combos = {{key = 'W', reformers = {'RWin'}}}, 		down = iCommandPlaneEmergencyBrake, up = iCommandPlaneEmergencyBrake, name = 'Emergency Wheel Brake', category = 'Systems'},
-- {combos = {{key = 'R', reformers = {'RWin'}}},  	down = iCommandReloadTables, name = 'Reload Cockpit', category = 'Debug'},

{combos = {{key = 'Home', reformers = {'RAlt'}}} , 	down = iCommandLeftEngineStart, name = 'Engine Start Left', category = 'Systems'},
{combos = {{key = 'Home', reformers = {'RCtrl'}}}, 	down = iCommandRightEngineStart, name = 'Engine Start Right', category = 'Systems'},
{combos = {{key = 'End', reformers = {'RAlt'}}} , 	down = iCommandLeftEngineStop, name = 'Engine Stop Left', category = 'Systems'},
{combos = {{key = 'End', reformers = {'RCtrl'}}}, 	down = iCommandRightEngineStop, name = 'Engine Stop Right', category = 'Systems'},
--{combos = {{key = 'R', reformers = {'LAlt'}}} , 	down = iCommandPlaneJettisonFuelTanks				 , name = 'Jettison Fuel Tanks', category = 'Systems'},
{combos = {{key = 'C', reformers = {'LCtrl'}}}, 	down = iCommandPlaneFonar, name = 'Canopy Open/Close', category = 'Systems'},
{combos = {{key = 'E', reformers = {'LCtrl'}}}, 	down = iCommandPlaneEject, name = 'Eject', category = 'Systems'},
{combos = {{key = 'L'}}, 							down = iCommandPlaneCockpitIllumination, name = 'Cockpit Illumination', category = 'Systems'},
{combos = {{key = 'L', reformers = {'RAlt'}}}, 		down = iCommandPlaneHeadLightOnOff, name = 'Gear Light Near/Far/Off', category = 'Systems'},
{combos = {{key = 'L', reformers = {'RCtrl'}}}, 	down = iCommandPlaneLightsOnOff, name = 'Navigation lights', category = 'Systems'},
{combos = {{key = 'T', reformers = {'LShift'}}}, 	down = iCommandPlaneWingtipSmokeOnOff, name = 'Smoke', category = 'Systems'},
-- {combos = {{key = 'N', reformers = {'RShift'}}}, 	down = iCommandPlaneResetMasterWarning, name = 'Reset Current Audible Warning', category = 'Systems'},
{combos = {{key = 'W', reformers = {'LCtrl'}}}, 	down = iCommandPlaneJettisonWeapons, name = 'Jettison Weapons', category = 'Systems'},
{combos = {{key = 'C', reformers = {'RWin'}}}, 		down = iCommandFlightClockReset, name = 'Start/Stop/Reset Flight Clock', category = 'Systems'},
-- {combos = {{key = '=', reformers = {'RShift'}}}, 	pressed = iCommandAltimeterPressureIncrease,	up = iCommandAltimeterPressureStop, name = 'Altimeter Pressure Increase Su-25T', category = 'Systems'},
-- {combos = {{key = '-', reformers = {'RShift'}}}, 	pressed = iCommandAltimeterPressureDecrease, up = iCommandAltimeterPressureStop, name = 'Altimeter Pressure Decrease Su-25T', category = 'Systems'},
{combos = {{key = 'H', reformers = {'RCtrl'}}}, 	down = iCommandBrightnessILS, name = 'HUD Color', category = 'Systems'},

{down = iCommand_FireExting_LeftEngineExting					, name = 'Left Engine T-Handle Fire Extinguisher'							, category = 'Fire Extinguishers System'},
{down = iCommand_FireExting_APUExting							, name = 'APU T-Handle Fire Extinguisher'									, category = 'Fire Extinguishers System'},
{down = iCommand_FireExting_RightEngineExting					, name = 'Right Engine T-Handle Fire Extinguisher'							, category = 'Fire Extinguishers System'},
{down = iCommand_FireExting_Discharge_Left						, name = 'Fire Extinguishig Agent Discharge Left'							, category = 'Fire Extinguishers System'},
{down = iCommand_FireExting_Discharge_Center					, name = 'Fire Extinguishig Agent Discharge Off'							, category = 'Fire Extinguishers System'},
{down = iCommand_FireExting_Discharge_Right						, name = 'Fire Extinguishig Agent Discharge Right'							, category = 'Fire Extinguishers System'},

{down = iCommandPlaneTrimOn, up = iCommandPlaneTrimOff, name = 'Stick to trimmer control mode', category = 'Flight Control'},

-- Autopilot
{combos = {{key = 'A'}},down = iCommandPlaneAutopilot, up = iCommandPlaneAutopilot, name 		= 'LAAP Engage/Disengage'     , category = 'LASTE Control Panel'},
{combos = {{key = '2'}},down = iCommandPlaneStabPathHold, name = 'LAAP Path Hold'			  , category = 'LASTE Control Panel'},
{combos = {{key = '3'}},down = iCommandPlaneStabHbarHeading, name = 'LAAP Altitude/Heading Hold', category = 'LASTE Control Panel'},
{combos = {{key = '4'}},down = iCommandPlaneStabHbarBank, name 	= 'LAAP Altitude/Bank Hold'   , category = 'LASTE Control Panel'},
{down = iCommandPlane_EAC_ARM, up = iCommandPlane_EAC_ARM, name = 'EAC Arm', category = 'LASTE Control Panel'},
{down = iCommandPlane_EAC_OFF, up = iCommandPlane_EAC_OFF, name = 'EAC Off', category = 'LASTE Control Panel'},
{down = iCommandPlane_RDR_ALTM_NRM, name = 'RDR ALTM Normal', category = 'LASTE Control Panel'},
{down = iCommandPlane_RDR_ALTM_DIS, name = 'RDR ALTM Disable', category = 'LASTE Control Panel'},

-- Engine Control Panel

{down = iCommandPlane_LG_WRN_Silence		, up = iCommandPlane_LG_WRN_Silence		, name = 'Landing Gear Warning Silence'			, category = 'Engine Control Panel'},
{down = iCommandPlane_APU_Start														, name = 'APU Start'							, category = 'Engine Control Panel'},
{down = iCommandPlane_APU_Off														, name = 'APU Off'								, category = 'Engine Control Panel'},
{down = iCommandPlane_L_ENG_OPER_Ign 		, up = iCommandPlane_L_ENG_OPER_Norm	, name = 'Left Engine Oper Ign / Norm'			, category = 'Engine Control Panel'},
{down = iCommandPlane_L_ENG_OPER_Motor												, name = 'Left Engine Oper Motor'				, category = 'Engine Control Panel'},
{down = iCommandPlane_L_ENG_OPER_Norm												, name = 'Left Engine Oper Norm'				, category = 'Engine Control Panel'},
{down = iCommandPlane_R_ENG_OPER_Ign 		, up = iCommandPlane_R_ENG_OPER_Norm	, name = 'Right Engine Oper Ign / Norm'			, category = 'Engine Control Panel'},
{down = iCommandPlane_R_ENG_OPER_Motor												, name = 'Right Engine Oper Motor'				, category = 'Engine Control Panel'},
{down = iCommandPlane_R_ENG_OPER_Norm												, name = 'Right Engine Oper Norm'				, category = 'Engine Control Panel'},
{down = iCommandPlane_L_ENG_FUEL_FLOW_Norm											, name = 'Left Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'},
{down = iCommandPlane_L_ENG_FUEL_FLOW_Override										, name = 'Left Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'},
{down = iCommandPlane_R_ENG_FUEL_FLOW_Norm											, name = 'Right Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'},
{down = iCommandPlane_R_ENG_FUEL_FLOW_Override										, name = 'Right Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'},
{pressed = iCommandPlaneThrottleFrictionDec											, name = 'Throttle Friction Decrease'			, category = 'Engine Control Panel'},
{pressed = iCommandPlaneThrottleFrictionInc											, name = 'Throttle Friction Increase'			, category = 'Engine Control Panel'},


--NightVision
{combos = {{key = 'H', reformers = {'RShift'}}}		   , down    = iCommandViewNightVisionGogglesOn   , name = 'Toggle goggles'   , category = 'Sensors'},
{combos = {{key = 'H', reformers = {'RShift','RCtrl'}}}, pressed = iCommandPlane_Helmet_Brightess_Up  , name = 'Gain goggles up'  , category = 'Sensors'},
{combos = {{key = 'H', reformers = {'RShift','RAlt'}}} , pressed = iCommandPlane_Helmet_Brightess_Down, name = 'Gain goggles down', category = 'Sensors'},

--FAC
--{combos = {{key = 'B', reformers = {'LWin'}}}, down = iCommandViewBinocular , name = 'Binocular view toggle', category = 'FAC'},
--{combos = {{key = 'L', reformers = {'LAlt'}}}, down = iCommandViewLaserOnOff, name = 'Binocular laser illumination toggle', category = 'FAC'},
--{combos = {{key = 'Z', reformers = {'LWin'}}}, down = iCommandViewIR		, name = 'Binocular view IR mode', category = 'FAC'},

-- Left MFCD
{down = iCommandPlaneLeftMFD_OSB1 , up = iCommandPlaneLeftMFD_OSB1_Off,  name = 'Left MFCD OSB 01', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB2 , up = iCommandPlaneLeftMFD_OSB2_Off,  name = 'Left MFCD OSB 02', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB3 , up = iCommandPlaneLeftMFD_OSB3_Off,  name = 'Left MFCD OSB 03', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB4 , up = iCommandPlaneLeftMFD_OSB4_Off,  name = 'Left MFCD OSB 04', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB5 , up = iCommandPlaneLeftMFD_OSB5_Off,  name = 'Left MFCD OSB 05', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB6 , up = iCommandPlaneLeftMFD_OSB6_Off,  name = 'Left MFCD OSB 06', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB7 , up = iCommandPlaneLeftMFD_OSB7_Off,  name = 'Left MFCD OSB 07', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB8 , up = iCommandPlaneLeftMFD_OSB8_Off,  name = 'Left MFCD OSB 08', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB9 , up = iCommandPlaneLeftMFD_OSB9_Off,  name = 'Left MFCD OSB 09', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB10, up = iCommandPlaneLeftMFD_OSB10_Off, name = 'Left MFCD OSB 10', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB11, up = iCommandPlaneLeftMFD_OSB11_Off, name = 'Left MFCD OSB 11', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB12, up = iCommandPlaneLeftMFD_OSB12_Off, name = 'Left MFCD OSB 12', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB13, up = iCommandPlaneLeftMFD_OSB13_Off, name = 'Left MFCD OSB 13', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB14, up = iCommandPlaneLeftMFD_OSB14_Off, name = 'Left MFCD OSB 14', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB15, up = iCommandPlaneLeftMFD_OSB15_Off, name = 'Left MFCD OSB 15', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB16, up = iCommandPlaneLeftMFD_OSB16_Off, name = 'Left MFCD OSB 16', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB17, up = iCommandPlaneLeftMFD_OSB17_Off, name = 'Left MFCD OSB 17', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB18, up = iCommandPlaneLeftMFD_OSB18_Off, name = 'Left MFCD OSB 18', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB19, up = iCommandPlaneLeftMFD_OSB19_Off, name = 'Left MFCD OSB 19', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_OSB20, up = iCommandPlaneLeftMFD_OSB20_Off, name = 'Left MFCD OSB 20', category = 'Left MFCD'},


{down = iCommandPlaneLeftMFD_ADJ_Increase, up = iCommandPlaneLeftMFD_ADJ_Stop, name = 'Left MFCD ADJ Increase', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_ADJ_Decrease, up = iCommandPlaneLeftMFD_ADJ_Stop, name = 'Left MFCD ADJ Decrease', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_DSP_Increase, up = iCommandPlaneLeftMFD_DSP_Stop, name = 'Left MFCD DSP Increase', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_DSP_Decrease, up = iCommandPlaneLeftMFD_DSP_Stop, name = 'Left MFCD DSP Decrease', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_BRT_Increase, up = iCommandPlaneLeftMFD_BRT_Stop, name = 'Left MFCD BRT Increase', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_BRT_Decrease, up = iCommandPlaneLeftMFD_BRT_Stop, name = 'Left MFCD BRT Decrease', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_CON_Increase, up = iCommandPlaneLeftMFD_CON_Stop, name = 'Left MFCD CON Increase', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_CON_Decrease, up = iCommandPlaneLeftMFD_CON_Stop, name = 'Left MFCD CON Decrease', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_SYM_Up	  	 , up = iCommandPlaneLeftMFD_SYM_Stop, name = 'Left MFCD SYM Increase', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_SYM_Dn	  	 , up = iCommandPlaneLeftMFD_SYM_Stop, name = 'Left MFCD SYM Decrease', category = 'Left MFCD'},

{down = iCommandPlaneLeftMFD_BRTMODE_OFF		, name = 'Left MFCD Disable power', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_BRTMODE_NIGHT	, name = 'Left MFCD Night illumination', category = 'Left MFCD'},
{down = iCommandPlaneLeftMFD_BRTMODE_DAY		, name = 'Left MFCD Day illumination', category = 'Left MFCD'},

-- Right MFCD
{down = iCommandPlaneRightMFD_OSB1 , up = iCommandPlaneRightMFD_OSB1_Off,  name = 'Right MFCD OSB 01', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB2 , up = iCommandPlaneRightMFD_OSB2_Off,  name = 'Right MFCD OSB 02', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB3 , up = iCommandPlaneRightMFD_OSB3_Off,  name = 'Right MFCD OSB 03', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB4 , up = iCommandPlaneRightMFD_OSB4_Off,  name = 'Right MFCD OSB 04', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB5 , up = iCommandPlaneRightMFD_OSB5_Off,  name = 'Right MFCD OSB 05', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB6 , up = iCommandPlaneRightMFD_OSB6_Off,  name = 'Right MFCD OSB 06', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB7 , up = iCommandPlaneRightMFD_OSB7_Off,  name = 'Right MFCD OSB 07', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB8 , up = iCommandPlaneRightMFD_OSB8_Off,  name = 'Right MFCD OSB 08', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB9 , up = iCommandPlaneRightMFD_OSB9_Off,  name = 'Right MFCD OSB 09', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB10, up = iCommandPlaneRightMFD_OSB10_Off, name = 'Right MFCD OSB 10', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB11, up = iCommandPlaneRightMFD_OSB11_Off, name = 'Right MFCD OSB 11', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB12, up = iCommandPlaneRightMFD_OSB12_Off, name = 'Right MFCD OSB 12', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB13, up = iCommandPlaneRightMFD_OSB13_Off, name = 'Right MFCD OSB 13', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB14, up = iCommandPlaneRightMFD_OSB14_Off, name = 'Right MFCD OSB 14', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB15, up = iCommandPlaneRightMFD_OSB15_Off, name = 'Right MFCD OSB 15', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB16, up = iCommandPlaneRightMFD_OSB16_Off, name = 'Right MFCD OSB 16', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB17, up = iCommandPlaneRightMFD_OSB17_Off, name = 'Right MFCD OSB 17', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB18, up = iCommandPlaneRightMFD_OSB18_Off, name = 'Right MFCD OSB 18', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB19, up = iCommandPlaneRightMFD_OSB19_Off, name = 'Right MFCD OSB 19', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_OSB20, up = iCommandPlaneRightMFD_OSB20_Off, name = 'Right MFCD OSB 20', category = 'Right MFCD'},


{down = iCommandPlaneRightMFD_ADJ_Increase, up = iCommandPlaneRightMFD_ADJ_Stop, name = 'Right MFCD ADJ Increase', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_ADJ_Decrease, up = iCommandPlaneRightMFD_ADJ_Stop, name = 'Right MFCD ADJ Decrease', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_DSP_Increase, up = iCommandPlaneRightMFD_DSP_Stop, name = 'Right MFCD DSP Increase', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_DSP_Decrease, up = iCommandPlaneRightMFD_DSP_Stop, name = 'Right MFCD DSP Decrease', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_BRT_Increase, up = iCommandPlaneRightMFD_BRT_Stop, name = 'Right MFCD BRT Increase', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_BRT_Decrease, up = iCommandPlaneRightMFD_BRT_Stop, name = 'Right MFCD BRT Decrease', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_CON_Increase, up = iCommandPlaneRightMFD_CON_Stop, name = 'Right MFCD CON Increase', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_CON_Decrease, up = iCommandPlaneRightMFD_CON_Stop, name = 'Right MFCD CON Decrease', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_SYM_Up	  	 , up = iCommandPlaneRightMFD_SYM_Stop, name = 'Right MFCD SYM Increase', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_SYM_Dn	  	 , up = iCommandPlaneRightMFD_SYM_Stop, name = 'Right MFCD SYM Decrease', category = 'Right MFCD'},

{down = iCommandPlaneRightMFD_BRTMODE_OFF		, name = 'Right MFCD Disable power', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_BRTMODE_NIGHT		, name = 'Right MFCD Night illumination', category = 'Right MFCD'},
{down = iCommandPlaneRightMFD_BRTMODE_DAY		, name = 'Right MFCD Day illumination', category = 'Right MFCD'},

--Electrical power control panel
{down = iCommandAPUGeneratorPower								, name = 'APU generator power', category = 'Electrical power control panel'},
{down = iCommandElectricalPowerInverterSTBY						, name = 'Inverter STBY', category = 'Electrical power control panel'},
{down = iCommandElectricalPowerInverterOFF						, name = 'Inverter OFF', category = 'Electrical power control panel'},
{down = iCommandElectricalPowerInverterTEST,up = iCommandElectricalPowerInverterOFF, name = 'Inverter TEST', category = 'Electrical power control panel'},
{down = iCommandEmergencyFlood									, name = 'Emergency flood', category = 'Electrical power control panel'},
{down = iCommandPowerGeneratorLeft								, name = 'AC generator power left', category = 'Electrical power control panel'},
{down = iCommandPowerGeneratorRight								, name = 'AC generator power right', category = 'Electrical power control panel'},
{down = iCommandBatteryPower									, name = 'Battery power', category = 'Electrical power control panel'},

--Fuel system control panel
{down = iCommandPlaneFSExtTanksWingValve						, name = 'External tanks wing valve', category = 'Fuel system control panel'},
{down = iCommandPlaneFSExtTanksFuselageValve					, name = 'External tanks fuselage valve', category = 'Fuel system control panel'},
{down = iCommandPlaneFSSigAmplifier								, name = 'Refueling signal amplifier', category = 'Fuel system control panel'},
{down = iCommandPlaneFSLineCheck, up =iCommandPlaneFSLineCheck	, name = 'Air refuel line check', category = 'Fuel system control panel'},
{down = iCommandPlaneFSTankGate									, name = 'Tank gate valve', category = 'Fuel system control panel'},
{down = iCommandPlaneFSTankCrossFeed							, name = 'Fuel crossfeed valve', category = 'Fuel system control panel'},
{down = iCommandPlaneFSLeftWingBoostPump						, name = 'Left wing tank boost pump', category = 'Fuel system control panel'},
{down = iCommandPlaneFSRightWingBoostPump						, name = 'Right wing tank boost pump', category = 'Fuel system control panel'},
{down = iCommandPlaneFSLeftWingFillDisable						, name = 'Left wing tank fill disable', category = 'Fuel system control panel'},
{down = iCommandPlaneFSRightWingFillDisable						, name = 'Right wing tank fill disable', category = 'Fuel system control panel'},
{down = iCommandPlaneFSLeftMainBoostPump						, name = 'Left main tank boost pump', category = 'Fuel system control panel'},
{down = iCommandPlaneFSRightMainBoostPump						, name = 'Right main tank boost pump', category = 'Fuel system control panel'},
{down = iCommandPlaneFSLeftMainFillDisable						, name = 'Left main tank fill disable', category = 'Fuel system control panel'},
{down = iCommandPlaneFSRightMainFillDisable						, name = 'Right main tank fill disable', category = 'Fuel system control panel'},
{down = iCommandPlaneFSReceiverLever						    , name = 'Air refuel control', category = 'Fuel system control panel'},
{down = iCommandPlaneFSQuantityIndicatorSelectorINT				, name = 'Fuel quantity selector INT', category = 'Fuel system control panel'},
{down = iCommandPlaneFSQuantityIndicatorSelectorMAIN			, name = 'Fuel quantity selector MAIN', category = 'Fuel system control panel'},
{down = iCommandPlaneFSQuantityIndicatorSelectorWING			, name = 'Fuel quantity selector WING', category = 'Fuel system control panel'},
{down = iCommandPlaneFSQuantityIndicatorSelectorEXTWING			, name = 'Fuel quantity selector EXT WING', category = 'Fuel system control panel'},
{down = iCommandPlaneFSQuantityIndicatorSelectorEXTCTR			, name = 'Fuel quantity selector EXT CTR', category = 'Fuel system control panel'},
{down = iCommandPlaneFSQuantityIndicatorTest,up =iCommandPlaneFSQuantityIndicatorTest, name = 'Fuel quantity indicator test', category = 'Fuel system control panel'},
{pressed = iCommandPlaneFSRefuelLigtingDecrease,				name = 'RCVR Lights Decrease', category = 'Fuel system control panel'},
{pressed = iCommandPlaneFSRefuelLigtingIncrease,				name = 'RCVR Lights Increase', category = 'Fuel system control panel'},

--Emergency flight control panel
{down = iCommandPlaneEmerSpeedBrakeRetract						, name = 'Speed brake emer retract', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerPitchRollTrim							, name = 'Pitch/Roll trim NORM/OVERRIDE', category = 'Emergency flight control panel'},
{pressed = iCommandPlaneEmerTrimNoseDn,  up = iCommandPlaneEmerTrimNeutral	, name = 'Emer trim Nose DN', category = 'Emergency flight control panel'},
{pressed = iCommandPlaneEmerTrimLWingDn, up = iCommandPlaneEmerTrimNeutral	, name = 'Emer trim Left wing DN', category = 'Emergency flight control panel'},
{pressed = iCommandPlaneEmerTrimRWingDn, up = iCommandPlaneEmerTrimNeutral	, name = 'Emer trim Right wing DN', category = 'Emergency flight control panel'},
{pressed = iCommandPlaneEmerTrimNoseUP,  up = iCommandPlaneEmerTrimNeutral	, name = 'Emer trim Nose UP', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerAileronDisengageL  					, name = 'Left aileron emer disengage', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerAileronDisengageOff  					, name = 'Aileron emer disengage off', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerAileronDisengageR  					, name = 'Right aileron emer disengage', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerElevatorDisengageL  					, name = 'Left elevator emer disengage', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerElevatorDisengageOff  					, name = 'Elevator emer disengage off', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerElevatorDisengageR  					, name = 'Right elevator emer disengage', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerFlapsRetract  							, name = 'Flaps emer retract', category = 'Emergency flight control panel'},
{down = iCommandPlaneEmerFlightControl  						, name = 'Flight control NORM/MAN REVERSION', category = 'Emergency flight control panel'},

-- Circuit breaker panel
{down = iCommandPlaneCircuitBreaker_1							, name = 'Aileron diconnect Left', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_2							, name = 'Aileron diconnect Right', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_3							, name = 'SPS & Rudder AUTH Limit', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_4							, name = 'Elevator diconnect Left', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_5							, name = 'Elevator diconnect Right', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_6							, name = 'Aileron TAB Left', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_7							, name = 'Aileron TAB Right', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_8							, name = 'Emer FLAP', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_9							, name = 'Emer TRIM', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_10							, name = 'Land GEAR', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_11							, name = 'Engine start Left', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_12							, name = 'Engine start Right', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_13							, name = 'APU CONT', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_14							, name = 'Engines ingnitor L/R-1', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_15							, name = 'Engines ingnitor L/R-2', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_16							, name = 'Emer fuel shutoff Left engine', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_17							, name = 'Emer fuel shutoff Rignt engine', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_18							, name = 'DC fuel pump', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_19							, name = 'Bleed air CONT Left', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_20							, name = 'Bleed air CONT Right', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_21							, name = 'Ext stores jettison 1', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_22							, name = 'Ext stores jettison 2', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_23							, name = 'Standby attitude indicator', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_24							, name = 'Master caution', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_25							, name = 'Pitot heat AC', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_26							, name = 'IFF', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_27							, name = 'UHF COM', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_28							, name = 'INTER COMM', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_29							, name = 'Generator CONT Left', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_30							, name = 'Generator CONT Right', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_31							, name = 'Converter L', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_32							, name = 'AUX ESS BUS 0A', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_33							, name = 'AUX ESS BUS 0B', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_34							, name = 'AUX ESS BUS 0C', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_35							, name = 'Battery bus transformer', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_36							, name = 'Inverter PWR', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_37							, name = 'Inverter CONT', category = 'Circuit breaker panel'},
{down = iCommandPlaneCircuitBreaker_38							, name = 'AUX ESS BUS TIE', category = 'Circuit breaker panel'},

--Stability Augmentation system panel
{combos = {{key = 'Z', reformers = {'RCtrl'}}}				, pressed = iCommandPlaneTrimLeftRudder ,name = 'Yaw Trim Left', category = 'Stability Augmentation System'},
{combos = {{key = 'X', reformers = {'RCtrl'}}}				, pressed = iCommandPlaneTrimRightRudder,name = 'Yaw Trim Right', category = 'Stability Augmentation System'},
{down = iCommandPlaneYawSASEngageL							, name = 'Yaw SAS engage Left', category = 'Stability Augmentation System'},
{down = iCommandPlaneYawSASEngageR							, name = 'Yaw SAS engage Right', category = 'Stability Augmentation System'},
{down = iCommandPlanePitchSASEngageL						, name = 'Pitch SAS engage Left', category = 'Stability Augmentation System'},
{down = iCommandPlanePitchSASEngageR						, name = 'Pitch SAS engage Right', category = 'Stability Augmentation System'},
{down = iCommandPlaneSASMonitorTestLeft						, name = 'Monitor test Left', category = 'Stability Augmentation System'},
{down = iCommandPlaneSASMonitorTestOff						, name = 'Monitor test Off', category = 'Stability Augmentation System'},
{down = iCommandPlaneSASMonitorTestRight					, name = 'Monitor test Right', category = 'Stability Augmentation System'},
{down = iCommandPlaneSASTakeOffTrim, up = iCommandPlaneSASTakeOffTrim, name = 'Take off trim', category = 'Stability Augmentation System'},

--Intercom Control panel
{pressed = iCommandPlaneIntercomINTDecrease				, name = 'INT volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomINTIncrease				, name = 'INT volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomINTPress					, name = 'INT press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomFMDecrease				, name = 'FM volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomFMIncrease				, name = 'FM volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomFMPress					, name = 'FM press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomVHFDecrease				, name = 'VHF volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomVHFIncrease				, name = 'VHF volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomVHFPress					, name = 'VHF press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomUHFDecrease				, name = 'UHF volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomUHFIncrease				, name = 'UHF volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomUHFPress					, name = 'UHF press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomAIMDecrease				, name = 'AIM volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomAIMIncrease				, name = 'AIM volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomAIMPress					, name = 'AIM press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomIFFDecrease				, name = 'IFF volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomIFFIncrease				, name = 'IFF volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomIFFPress					, name = 'IFF press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomILSDecrease				, name = 'ILS volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomILSIncrease				, name = 'ILS volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomILSPress					, name = 'ILS press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomTCNDecrease				, name = 'TCN volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomTCNIncrease				, name = 'TCN volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomTCNPress					, name = 'TCN press', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomVolumeDecrease			, name = 'Volume volume decrease', category = 'Intercom control panel'},
{pressed = iCommandPlaneIntercomVolumeIncrease			, name = 'Volume volume increase', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomHM							, name = 'HM press', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomINT						, name = 'Rotary selector INT', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomVHF						, name = 'Rotary selector VHF', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomFM							, name = 'Rotary selector FM', category = 'Intercom control panel'},
{down = iCommandPlaneIntercomHF							, name = 'Rotary selector HF', category = 'Intercom control panel'},

--Auxiliary lighting control panel
{pressed = iCommandPlaneRefuelStatusIndLTSDecrease		, name = 'Refuel status indexer LTS Decrease', category = 'Auxiliary lighting control panel'},
{pressed = iCommandPlaneRefuelStatusIndLTSIncrease		, name = 'Refuel status indexer LTS Increase', category = 'Auxiliary lighting control panel'},
{down = iCommandPlaneNightVisionLTSTCP					, name = 'NVIS LTS TCP', category = 'Auxiliary lighting control panel'},
{down = iCommandPlaneNightVisionLTSALL					, name = 'NVIS LTS ALL', category = 'Auxiliary lighting control panel'},
{down = iCommandPlaneNightVisionLTSOFF					, name = 'NVIS LTS OFF', category = 'Auxiliary lighting control panel'},
--{pressed = iCommandPlaneWeaponStationLTSOff			, name = 'Weapon station status LTS decrease', category = 'Auxiliary lighting control panel'},
--{pressed = iCommandPlaneWeaponStationLTSBrt			, name = 'Weapon station status LTS increase', category = 'Auxiliary lighting control panel'},
{down = iCommandPlaneHarsSasNormOverride				, name = 'HARS/SAS OVERRIDE/NORM', category = 'Auxiliary lighting control panel'},
{combos = {{key = 'L', reformers = {'LShift'}}}, down = iCommandLampsControl, up = iCommandLampsControl_up, name = 'Signal lights lamp test', category = 'Auxiliary lighting control panel'},
{down = iCommandPlaneFireDetectBleedAirTest,up = 	iCommandPlaneFireDetectBleedAirTest, name = 'Fire detect bleed air leak test', category = 'Auxiliary lighting control panel'},

--UHF Radio
{pressed = iCommandPlaneUHFPresetChannelSelectorDec		, name = 'UHF Preset chanel selector decrease', category = 'UHF Radio'},
{pressed = iCommandPlaneUHFPresetChannelSelectorInc		, name = 'UHF Preset chanel selector increase', category = 'UHF Radio'},
{down = iCommandPlaneUHF100MhzSelector1					, name = 'UHF 100Mhz selector switch 1', category = 'UHF Radio'},
{down = iCommandPlaneUHF100MhzSelector2					, name = 'UHF 100Mhz selector switch 2', category = 'UHF Radio'},
{down = iCommandPlaneUHF100MhzSelector3					, name = 'UHF 100Mhz selector switch 3', category = 'UHF Radio'},
{down = iCommandPlaneUHF100MhzSelectorA					, name = 'UHF 100Mhz selector switch A', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF10MhzSelectorDec				, name = 'UHF 10Mhz selector decrease', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF10MhzSelectorInc				, name = 'UHF 10Mhz selector increase', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF1MhzSelectorDec				, name = 'UHF 1Mhz selector decrease', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF1MhzSelectorInc				, name = 'UHF 1Mhz selector increase', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF01MhzSelectorDec				, name = 'UHF 0.1Mhz selector decrease', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF01MhzSelectorInc				, name = 'UHF 0.1Mhz selector increase', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF0025MhzSelectorDec			, name = 'UHF 0.025Mhz selector decrease', category = 'UHF Radio'},
{pressed = iCommandPlaneUHF0025MhzSelectorInc			, name = 'UHF 0.025Mhz selector increase', category = 'UHF Radio'},
{down = iCommandPlaneUHFTestDisplay,up = iCommandPlaneUHFTestDisplay, name = 'UHF Test display', category = 'UHF Radio'},
{down = iCommandPlaneUHFStatus,up = iCommandPlaneUHFStatus, name = 'UHF Status', category = 'UHF Radio'},
{down = iCommandPlaneUHFLoad,up = iCommandPlaneUHFLoad, name = 'UHF Load', category = 'UHF Radio'},
{pressed = iCommandPlaneUHFVolumeDec					, name = 'UHF Volume decrease', category = 'UHF Radio'},
{pressed = iCommandPlaneUHFVolumeInc					, name = 'UHF Volume increase', category = 'UHF Radio'},
{down = iCommandPlaneUHFFunctionDialOFF					, name = 'UHF Dial OFF', category = 'UHF Radio'},
{down = iCommandPlaneUHFFunctionDialMAIN				, name = 'UHF Dial MAIN', category = 'UHF Radio'},
{down = iCommandPlaneUHFFunctionDialBOTH				, name = 'UHF Dial BOTH', category = 'UHF Radio'},
{down = iCommandPlaneUHFFunctionDialADF					, name = 'UHF Dial ADF', category = 'UHF Radio'},
{down = iCommandPlaneUHFFreqModeDialMNL					, name = 'UHF Freq mode MNL', category = 'UHF Radio'},
{down = iCommandPlaneUHFFreqModeDialPRESET				, name = 'UHF Freq mode PRESET', category = 'UHF Radio'},
{down = iCommandPlaneUHFFreqModeDialGRD					, name = 'UHF Freq mode GRD', category = 'UHF Radio'},
{down = iCommandPlaneUHFTTone,up = iCommandPlaneUHFTTone, name = 'UHF T-Tone', category = 'UHF Radio'},
{down = iCommandPlaneUHFSquelch							, name = 'UHF Squelch ON/OFF', category = 'UHF Radio'},
{down = iCommandPlaneUHFPanelCover						, name = 'UHF Panel cover', category = 'UHF Radio'},

--CDU Panel
{down = iCommandPlaneCDU_LSK_3L,up = iCommandPlaneCDU_LSK_3L, name = 'CDU LSK L3', category = 'CDU panel'},
{down = iCommandPlaneCDU_LSK_5L,up = iCommandPlaneCDU_LSK_5L, name = 'CDU LSK L5', category = 'CDU panel'},
{down = iCommandPlaneCDU_LSK_7L,up = iCommandPlaneCDU_LSK_7L, name = 'CDU LSK L7', category = 'CDU panel'},
{down = iCommandPlaneCDU_LSK_9L,up = iCommandPlaneCDU_LSK_9L, name = 'CDU LSK L9', category = 'CDU panel'},
{down = iCommandPlaneCDU_LSK_3R,up = iCommandPlaneCDU_LSK_3R, name = 'CDU LSK R3', category = 'CDU panel'},
{down = iCommandPlaneCDU_LSK_5R,up = iCommandPlaneCDU_LSK_5R, name = 'CDU LSK R5', category = 'CDU panel'},
{down = iCommandPlaneCDU_LSK_7R,up = iCommandPlaneCDU_LSK_7R, name = 'CDU LSK R7', category = 'CDU panel'},
{down = iCommandPlaneCDU_LSK_9R,up = iCommandPlaneCDU_LSK_9R, name = 'CDU LSK R9', category = 'CDU panel'},
{down = iCommandPlaneCDU_SYS,up = iCommandPlaneCDU_SYS, 	  name = 'CDU SYS Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_NAV,up = iCommandPlaneCDU_NAV, 	  name = 'CDU NAV Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_WP,up = iCommandPlaneCDU_WP, 		  name = 'CDU WP Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_OSET,up = iCommandPlaneCDU_OSET, 	  name = 'CDU OSET Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_FPM,up = iCommandPlaneCDU_FPM, 	  name = 'CDU FPM Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_PREV,up = iCommandPlaneCDU_PREV, 	  name = 'CDU PREV Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_DIM,up = iCommandPlaneCDU_DIM, 	  name = 'CDU DIM Rocker switch', category = 'CDU panel'},
{down = iCommandPlaneCDU_BRT,up = iCommandPlaneCDU_BRT, 	  name = 'CDU BRT Rocker switch', category = 'CDU panel'},
{down = iCommandPlaneCDU_1,up = iCommandPlaneCDU_1, 	      name = 'CDU 1 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_2,up = iCommandPlaneCDU_2, 	      name = 'CDU 2 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_3,up = iCommandPlaneCDU_3, 	      name = 'CDU 3 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_4,up = iCommandPlaneCDU_4, 	      name = 'CDU 4 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_5,up = iCommandPlaneCDU_5, 	      name = 'CDU 5 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_6,up = iCommandPlaneCDU_6, 	      name = 'CDU 6 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_7,up = iCommandPlaneCDU_7, 	      name = 'CDU 7 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_8,up = iCommandPlaneCDU_8, 	      name = 'CDU 8 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_9,up = iCommandPlaneCDU_9, 	      name = 'CDU 9 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_0,up = iCommandPlaneCDU_0, 	      name = 'CDU 0 Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_PNT,up = iCommandPlaneCDU_PNT, 	  name = 'CDU Point Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_SLASH,up = iCommandPlaneCDU_SLASH,	  name = 'CDU Slash Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_A,up = iCommandPlaneCDU_A, 	      name = 'CDU A Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_B,up = iCommandPlaneCDU_B, 	      name = 'CDU B Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_C,up = iCommandPlaneCDU_C, 	      name = 'CDU C Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_D,up = iCommandPlaneCDU_D, 	      name = 'CDU D Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_E,up = iCommandPlaneCDU_E, 	      name = 'CDU E Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_F,up = iCommandPlaneCDU_F, 	      name = 'CDU F Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_G,up = iCommandPlaneCDU_G, 	      name = 'CDU G Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_H,up = iCommandPlaneCDU_H, 	      name = 'CDU H Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_I,up = iCommandPlaneCDU_I, 	      name = 'CDU I Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_J,up = iCommandPlaneCDU_J, 	      name = 'CDU J Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_K,up = iCommandPlaneCDU_K, 	      name = 'CDU K Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_L,up = iCommandPlaneCDU_L, 	      name = 'CDU L Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_M,up = iCommandPlaneCDU_M, 	      name = 'CDU M Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_N,up = iCommandPlaneCDU_N, 	      name = 'CDU N Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_O,up = iCommandPlaneCDU_O, 	      name = 'CDU O Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_P,up = iCommandPlaneCDU_P, 	      name = 'CDU P Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_Q,up = iCommandPlaneCDU_Q, 	      name = 'CDU Q Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_R,up = iCommandPlaneCDU_R, 	      name = 'CDU R Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_S,up = iCommandPlaneCDU_S, 	      name = 'CDU S Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_T,up = iCommandPlaneCDU_T, 	      name = 'CDU T Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_U,up = iCommandPlaneCDU_U, 	      name = 'CDU U Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_V,up = iCommandPlaneCDU_V, 	      name = 'CDU V Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_W,up = iCommandPlaneCDU_W, 	      name = 'CDU W Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_X,up = iCommandPlaneCDU_X, 	      name = 'CDU X Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_Y,up = iCommandPlaneCDU_Y, 	      name = 'CDU Y Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_Z,up = iCommandPlaneCDU_Z, 	      name = 'CDU Z Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_PLUS,up = iCommandPlaneCDU_PLUS, 	  name = 'CDU PLUS Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_MINUS,up = iCommandPlaneCDU_MINUS,   name = 'CDU MINUS Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_PGUP,up = iCommandPlaneCDU_PGUP, 	  name = 'CDU PG UP Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_PGDN,up = iCommandPlaneCDU_PGDN, 	  name = 'CDU PG DN Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_BLANC_L,up = iCommandPlaneCDU_BLANC_L,name = 'CDU Search back Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_BLANC_R,up = iCommandPlaneCDU_BLANC_R,name = 'CDU Search forward Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_MK,up = iCommandPlaneCDU_MK,		   	name = 'CDU MK Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_BCK,up = iCommandPlaneCDU_BCK,		   	name = 'CDU BCK Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_SPC,up = iCommandPlaneCDU_SPC,			name = 'CDU SPC Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_CLR,up = iCommandPlaneCDU_CLR,			name = 'CDU CLR Key', category = 'CDU panel'},
{down = iCommandPlaneCDU_FA,up = iCommandPlaneCDU_FA,			name = 'CDU FA Key', category = 'CDU panel'},

--UFC panel
{down = iCommandPlaneUFC_1,up = iCommandPlaneUFC_1, 	      name = 'UFC 1 Key', category = 'UFC'},
{down = iCommandPlaneUFC_2,up = iCommandPlaneUFC_2, 	      name = 'UFC 2 Key', category = 'UFC'},
{down = iCommandPlaneUFC_3,up = iCommandPlaneUFC_3, 	      name = 'UFC 3 Key', category = 'UFC'},
{down = iCommandPlaneUFC_4,up = iCommandPlaneUFC_4, 	      name = 'UFC 4 Key', category = 'UFC'},
{down = iCommandPlaneUFC_5,up = iCommandPlaneUFC_5, 	      name = 'UFC 5 Key', category = 'UFC'},
{down = iCommandPlaneUFC_6,up = iCommandPlaneUFC_6, 	      name = 'UFC 6 Key', category = 'UFC'},
{down = iCommandPlaneUFC_7,up = iCommandPlaneUFC_7, 	      name = 'UFC 7 Key', category = 'UFC'},
{down = iCommandPlaneUFC_8,up = iCommandPlaneUFC_8, 	      name = 'UFC 8 Key', category = 'UFC'},
{down = iCommandPlaneUFC_9,up = iCommandPlaneUFC_9, 	      name = 'UFC 9 Key', category = 'UFC'},
{down = iCommandPlaneUFC_0,up = iCommandPlaneUFC_0, 	      name = 'UFC 0 Key', category = 'UFC'},
{down = iCommandPlaneUFC_SPC,up = iCommandPlaneUFC_SPC, 	  name = 'UFC SPC Key', category = 'UFC'},
{down = iCommandPlaneUFC_HACK,up = iCommandPlaneUFC_HACK, 	  name = 'UFC HACK Key', category = 'UFC'},
{down = iCommandPlaneUFC_FUNC,up = iCommandPlaneUFC_FUNC, 	  name = 'UFC FUNC Key', category = 'UFC'},
{down = iCommandPlaneUFC_LTR,up = iCommandPlaneUFC_LTR, 	  name = 'UFC LTR Key', category = 'UFC'},
{down = iCommandPlaneUFC_CLR,up = iCommandPlaneUFC_CLR, 	  name = 'UFC CLR Key', category = 'UFC'},
{down = iCommandPlaneUFC_ENT,up = iCommandPlaneUFC_ENT, 	  name = 'UFC ENT Key', category = 'UFC'},
{down = iCommandPlaneUFC_MK,up = iCommandPlaneUFC_MK, 	  	  name = 'UFC MK Key', category = 'UFC'},
{down = iCommandPlaneUFC_ALT,up = iCommandPlaneUFC_ALT, 	  name = 'UFC ALT Key', category = 'UFC'},
{down = iCommandPlaneUFC_MASTER_WARNING,up = iCommandPlaneUFC_MASTER_WARNING,	name = 'UFC Master Warning Key', category = 'UFC'},
{down = iCommandPlaneUFC_STEER_UP,up = iCommandPlaneUFC_STEER_UP,			 	name = 'UFC STEER UP Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_STEER_DOWN,up = iCommandPlaneUFC_STEER_DOWN,			name = 'UFC STEER DOWN Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_DATA_UP,up = iCommandPlaneUFC_DATA_UP,					name = 'UFC DATA UP Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_DATA_DOWN,up = iCommandPlaneUFC_DATA_DOWN,				name = 'UFC DATA DOWN Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_SEL_UP,up = iCommandPlaneUFC_SEL_UP,					name = 'UFC SEL UP Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_SEL_DOWN,up = iCommandPlaneUFC_SEL_DOWN,				name = 'UFC SEL DOWN Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_DEPR_UP,up = iCommandPlaneUFC_DEPR_UP,					name = 'UFC DEPR UP Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_DEPR_DOWN,up = iCommandPlaneUFC_DEPR_DOWN,				name = 'UFC DEPR DOWN Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_INTEN_INCREASE,up = iCommandPlaneUFC_INTEN_INCREASE,	name = 'UFC INTEN INCREASE Rocker switch', category = 'UFC'},
{down = iCommandPlaneUFC_INTEN_DECREASE,up = iCommandPlaneUFC_INTEN_DECREASE,	name = 'UFC INTEN DECREASE Rocker switch', category = 'UFC'},

--CMSP panel
{down = iCommandPlaneCMSP_OSB_1,up = iCommandPlaneCMSP_OSB_1, 	      	name = 'CMSP OSB1', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_OSB_2,up = iCommandPlaneCMSP_OSB_2, 	      	name = 'CMSP OSB2', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_OSB_3,up = iCommandPlaneCMSP_OSB_3, 	     	name = 'CMSP OSB3', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_OSB_4,up = iCommandPlaneCMSP_OSB_4, 	      	name = 'CMSP OSB4', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_NEXT_UP,up = iCommandPlaneCMSP_NEXT_UP, 	  	name = 'CMSP Next Up rotary', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_NEXT_DOWN,up = iCommandPlaneCMSP_NEXT_DOWN, 	name = 'CMSP Next Down rotary', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_RTN,up = iCommandPlaneCMSP_RTN, 			  	name = 'CMSP RTN Key', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_JTSN, 										name = 'CMSP JTSN', category = 'CMSP Panel'},
{pressed = iCommandPlaneCMSP_BRT_DEC,									name = 'CMSP BRT Decrease', category = 'CMSP Panel'},
{pressed = iCommandPlaneCMSP_BRT_INC,									name = 'CMSP BRT Increase', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_MWS_MENU,up = iCommandPlaneCMSP_MWS_ON, 		name = 'CMSP MWS MENU', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_MWS_ON, 										name = 'CMSP MWS ON/OFF', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_JMR_MENU,up = iCommandPlaneCMSP_JMR_ON, 		name = 'CMSP JMR MENU', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_JMR_ON, 										name = 'CMSP JMR ON/OFF', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_RWR_MENU,up = iCommandPlaneCMSP_RWR_ON, 		name = 'CMSP RWR MENU', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_RWR_ON, 										name = 'CMSP RWR ON/OFF', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_DISP_MENU,up = iCommandPlaneCMSP_DISP_ON, 	name = 'CMSP DISP MENU', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_DISP_ON, 										name = 'CMSP DISP ON/OFF', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_MODE_OFF, 									name = 'CMSP MODE OFF', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_MODE_STBY, 									name = 'CMSP MODE STBY', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_MODE_MAN, 									name = 'CMSP MODE MAN', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_MODE_SEMI, 									name = 'CMSP MODE SEMI', category = 'CMSP Panel'},
{down = iCommandPlaneCMSP_MODE_AUTO, 									name = 'CMSP MODE AUTO', category = 'CMSP Panel'},

--CMSC panel
{down = iCommandPlaneCMSC_JMR,up = iCommandPlaneCMSC_JMR, 	      		name = 'CMSC JMR Key', category = 'CMSC Panel'},
{down = iCommandPlaneCMSC_MWS,up = iCommandPlaneCMSC_MWS, 	      		name = 'CMSC MWS Key', category = 'CMSC Panel'},
{pressed = iCommandPlaneCMSC_BRT_DEC,									name = 'CMSC BRT Decrease', category = 'CMSC Panel'},
{pressed = iCommandPlaneCMSC_BRT_INC,									name = 'CMSC BRT Increase', category = 'CMSC Panel'},
{pressed = iCommandPlaneCMSC_AUD_DEC,									name = 'CMSC AUD Decrease', category = 'CMSC Panel'},
{pressed = iCommandPlaneCMSC_AUD_INC,									name = 'CMSC AUD Increase', category = 'CMSC Panel'},
{down = iCommandPlaneCMSC_PRI,up = iCommandPlaneCMSC_PRI, 	      		name = 'CMSC PRI Key', category = 'CMSC Panel'},
{down = iCommandPlaneCMSC_SEP,up = iCommandPlaneCMSC_SEP, 	      		name = 'CMSC SEP Key', category = 'CMSC Panel'},
{down = iCommandPlaneCMSC_UNK,up = iCommandPlaneCMSC_UNK, 	      		name = 'CMSC UNK Key', category = 'CMSC Panel'},

--Lighting control panel
{down = iCommandPlanePositionLightsFlash, 								name = 'Position Lights Flash', category = 'Lighting Panel'},
{down = iCommandPlanePositionLightsOff, 								name = 'Position Lights Off', category = 'Lighting Panel'},
{down = iCommandPlanePositionLightsSteady, 								name = 'Position Lights Steady', category = 'Lighting Panel'},
{pressed = iCommandPlaneFormationLightsDecrease,						name = 'Formation Lights Decrease', category = 'Lighting Panel'},
{pressed = iCommandPlaneFormationLightsIncrease,						name = 'Formation Lights Increase', category = 'Lighting Panel'},
{down = iCommandPlaneAntiCollisionLights, 								name = 'Anti-Collision Lights switch', category = 'Lighting Panel'},
{pressed = iCommandPlaneEngInstLightsDecrease,							name = 'Engine Instruments Lights Decrease', category = 'Lighting Panel'},
{pressed = iCommandPlaneEngInstLightsIncrease,							name = 'Engine Instruments Lights Increase', category = 'Lighting Panel'},
{down = iCommandPlaneNoseIllum, 										name = 'Nose Flooding and Nose Illimination switch', category = 'Lighting Panel'},
{pressed = iCommandPlaneAuxInstLightsDecrease,							name = 'Auxiliary Instruments Lights Decrease', category = 'Lighting Panel'},
{pressed = iCommandPlaneAuxInstLightsIncrease,							name = 'Auxiliary Instruments Lights Increase', category = 'Lighting Panel'},
{down = iCommandPlaneSignalLTS, 										name = 'Signal Lights switch', category = 'Lighting Panel'},
{pressed = iCommandPlaneFltInstLightsDecrease,							name = 'Flight Instruments Lights Decrease', category = 'Lighting Panel'},
{pressed = iCommandPlaneFltInstLightsIncrease,							name = 'Flight Instruments Lights Increase', category = 'Lighting Panel'},
{down = iCommandPlaneAccelCompLights, 									name = 'Accelerometer and Compass Light switch', category = 'Lighting Panel'},
{pressed = iCommandPlaneFloodLightsDecrease,							name = 'Floodlight Decrease', category = 'Lighting Panel'},
{pressed = iCommandPlaneFloodLightsIncrease,							name = 'Floodlight Increase', category = 'Lighting Panel'},
{pressed = iCommandPlaneConsoleLightsDecrease,							name = 'Console Light Decrease', category = 'Lighting Panel'},
{pressed = iCommandPlaneConsoleLightsIncrease,							name = 'Console Light Increase', category = 'Lighting Panel'},

--AHCP
{down = iCommandPlaneAHCPMasterArm, 									name = 'Master switch ARM', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPMasterSafe, 									name = 'Master switch SAFE', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPMasterTrain, 									name = 'Master switch TRAIN', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPGUNPACArm, 									name = 'GUN/PAC switch ARM', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPGUNSafe, 										name = 'GUN/PAC switch SAFE', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPGUNArm, 										name = 'GUN/PAC switch GUNARM', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPLaserArm, 										name = 'LASER switch ARM', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPLaserSafe, 									name = 'LASER switch SAFE', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPLaserTrain, 									name = 'LASER switch TRAIN', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPTGPOnOff, 										name = 'TGP switch ON/OFF', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPAltSCEBaro, 									name = 'ALT SCE switch BARO', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPAltSCEDelta, 									name = 'ALT SCE switch DELTA', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPAltSCERadar, 									name = 'ALT SCE switch RADAR', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPHUDModeDayNight, 								name = 'HUD Mode switch Day/Night', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPHUDModeNormSTBY, 								name = 'HUD Mode switch NORM/STBY', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPCICUOnOff, 									name = 'CICU switch ON/OFF', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPJTRSOnOff, 									name = 'JTRS switch ON/OFF', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPIFFCCOn, 										name = 'IFFCC switch ON', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPIFFCCTest, 									name = 'IFFCC switch TEST', category = 'Armament HUD Control Panel'},
{down = iCommandPlaneAHCPIFFCCOff, 										name = 'IFFCC switch OFF', category = 'Armament HUD Control Panel'},

--Landing gear panel
{combos = {{key = 'G'}},						 		 down = iCommandPlaneGear, name = 'Landing Gear Up/Down', category = 'Landing gear panel'},
{combos = {{key = 'G', reformers = {'LCtrl'}}} , 		 down = iCommandPlaneGearUp, name = 'Landing Gear Up', category = 'Landing gear panel'},
{combos = {{key = 'G', reformers = {'LShift'}}}, down = iCommandPlaneGearDown, name = 'Landing Gear Down', category = 'Landing gear panel'},
{combos = {{key = 'G', reformers = {'RAlt'}}}, 			 down = iCommandEmergencyGear, name = 'Emergency gear', category = 'Landing gear panel'},
{down = iCommandPlaneLGPAntiSkid, 								name = 'Anti-Skid ON/OFF', category = 'Landing gear panel'},
{down = iCommandPlaneLGPDownlockOverride,up=iCommandPlaneLGPDownlockOverride,name = 'Downlock Override', category = 'Landing gear panel'},
{down = iCommandPlaneLGPLandLight, 								name = 'Landing Lights On', category = 'Landing gear panel'},
{down = iCommandPlaneLGPLightsOff, 								name = 'Landing/Taxi Lights Off', category = 'Landing gear panel'},
{down = iCommandPlaneLGPTaxiLight, 								name = 'Taxi Lights On', category = 'Landing gear panel'},

--NMSP
{down = iCommandPlaneNMSP_HARS, up = iCommandPlaneNMSP_HARS,  	name = 'NMSP HARS button', category = 'Navigation Mode Select Panel'},
{down = iCommandPlaneNMSP_EGI,up = iCommandPlaneNMSP_EGI, 		name = 'NMSP EGI button', category = 'Navigation Mode Select Panel'},
{down = iCommandPlaneNMSP_TISL, up = iCommandPlaneNMSP_TISL,  	name = 'NMSP TISL button', category = 'Navigation Mode Select Panel'},
{down = iCommandPlaneNMSP_STRPT, up = iCommandPlaneNMSP_STRPT,	name = 'NMSP STR PT button', category = 'Navigation Mode Select Panel'},
{down = iCommandPlaneNMSP_ANCHR, up = iCommandPlaneNMSP_ANCHR,	name = 'NMSP ANCHR button', category = 'Navigation Mode Select Panel'},
{down = iCommandPlaneNMSP_TCN, up = iCommandPlaneNMSP_TCN, 		name = 'NMSP TCN button', category = 'Navigation Mode Select Panel'},
{down = iCommandPlaneNMSP_ILS, up = iCommandPlaneNMSP_ILS,		name = 'NMSP ILS button', category = 'Navigation Mode Select Panel'},
{down = iCommandPlaneNMSP_PTR_ABLE_STOW, 						name = 'NMSP ABLE/STOW switch', category = 'Navigation Mode Select Panel'},

--TISL Control Panel. Not Impl
--[[{down = iCommandPlaneTISL_MODE_OFF, 						name = 'TISL Mode Selector OFF', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_MODE_CAGE, 						name = 'TISL Mode Selector OFF', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_MODE_DIVE, 						name = 'TISL Mode Selector OFF', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_MODE_LVLBAR, 						name = 'TISL Mode Selector OFF', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_MODE_LVLWIDE, 					name = 'TISL Mode Selector OFF', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_OVER10, 							name = 'TISL Slant Range Selector OVER 10', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_5_10, 							name = 'TISL Slant Range Selector 5-10', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_UNDER5, 							name = 'TISL Slant Range Selector UNDER 5', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE_TISL, 						name = 'TISL Code Select TISL', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE_BOTH, 						name = 'TISL Code Select BOTH', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE_AUX, 						name = 'TISL Code Select AUX', category = 'TISL Control Panel'},

{down = iCommandPlaneTISL_ENTER,up = iCommandPlaneTISL_ENTER, 	name = 'TISL Enter Button', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_TRACK,up = iCommandPlaneTISL_TRACK, 	name = 'TISL Track Light', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_OVERTEMP,up = iCommandPlaneTISL_OVERTEMP, name = 'TISL Over Temperature Light', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_BITE,up = iCommandPlaneTISL_BITE, 	name = 'BITE Button', category = 'TISL Control Panel'},

{down = iCommandPlaneTISL_ATAT1_UP, 							name = 'TISL Altitude Above Target Wheel1 Up', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_ATAT1_DOWN, 							name = 'TISL Altitude Above Target Wheel1 Down', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_ATAT2_UP, 							name = 'TISL Altitude Above Target Wheel2 Up', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_ATAT2_DOWN, 							name = 'TISL Altitude Above Target Wheel2 Down', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE1_UP, 							name = 'TISL Code Select Wheel1 Up', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE1_DOWN, 							name = 'TISL Code Select Wheel1 Down', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE2_UP, 							name = 'TISL Code Select Wheel2 Up', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE2_DOWN, 							name = 'TISL Code Select Wheel2 Down', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE3_UP, 							name = 'TISL Code Select Wheel3 Up', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE3_DOWN, 							name = 'TISL Code Select Wheel3 Down', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE4_UP, 							name = 'TISL Code Select Wheel4 Up', category = 'TISL Control Panel'},
{down = iCommandPlaneTISL_CODE4_DOWN, 							name = 'TISL Code Select Wheel4 Down', category = 'TISL Control Panel'},
]]

--SAI
{pressed = iCommand_AGR_axis_left, 							name = 'SAI Pitch Trim Left', category = 'Systems'},
{pressed = iCommand_AGR_axis_right, 						name = 'SAI Pitch Trim Right', category = 'Systems'},
{down = iCommand_AGR_Oriet, up = iCommand_AGR_Oriet, 		name = 'SAI Cage Knob', category = 'Systems'},

--ADI
{pressed = iCommandADI_ZeroPitchTrimLeft, 					name = 'ADI Pitch Trim Left', category = 'Systems'},
{pressed = iCommandADI_ZeroPitchTrimRight, 					name = 'ADI Pitch Trim Right', category = 'Systems'},

--Clock
{down = iCommandMechClock_LeftLever_Down, up = iCommandMechClock_LeftLever_Down,  name = 'CLOCK Select button', category = 'Systems'},
{down = iCommandMechClock_RightLever_Down, up = iCommandMechClock_RightLever_Down,name = 'CLOCK Control button', category = 'Systems'},

--HSI
{pressed = iCommandHSI_HeadingRotaryLeft,  					name = 'HSI Heading rotate left', category = 'Systems'},
{pressed = iCommandHSI_HeadingRotaryRight,					name = 'HSI Heading rotate right', category = 'Systems'},
{pressed = iCommandHSI_CourseRotaryLeft,  					name = 'HSI Course rotate left', category = 'Systems'},
{pressed = iCommandHSI_CourseRotaryRight,					name = 'HSI Course rotate right', category = 'Systems'},

--HARS fast erect
{down = iCommandPlane_HARS_Fast_Erect,	up = iCommandPlane_HARS_Fast_Erect, name = 'HARS Fast Erect Button', category = 'Systems'},

--Altimeter
{pressed = iCommandAltimeterPressureDecrease,  				name = 'Altimeter Pressure Set Decrease', category = 'Systems'},
{pressed = iCommandAltimeterPressureIncrease,				name = 'Altimeter Pressure Set Increase', category = 'Systems'},
{down = iCommandPlane_Altimeter_PNEU_Elect, 				name = 'Altimeter PNEU/ELECT Switch', category = 'Systems'},

--Auxiliary Avionics Panel AAP
{down = iCommandPlane_AAP_CDU_Power, 					name = 'AAP CDU Power Switch', category = 'AAP'},
{down = iCommandPlane_AAP_EGI_Power, 					name = 'AAP EGI Power Switch', category = 'AAP'},
{down = iCommandPlane_AAP_PageSel_OTHER, 				name = 'AAP Page Select OTHER', category = 'AAP'},
{down = iCommandPlane_AAP_PageSel_POSITION, 			name = 'AAP Page Select POSITION', category = 'AAP'},
{down = iCommandPlane_AAP_PageSel_STEER, 				name = 'AAP Page Select STEER', category = 'AAP'},
{down = iCommandPlane_AAP_PageSel_WAYPT, 				name = 'AAP Page Select WAYPT', category = 'AAP'},
{down = iCommandPlane_AAP_SteerPt_FLTPLAN, 				name = 'AAP Steer Point FLT PLAN', category = 'AAP'},
{down = iCommandPlane_AAP_SteerPt_MARK, 				name = 'AAP Steer Point MARK', category = 'AAP'},
{down = iCommandPlane_AAP_SteerPt_MISSION, 				name = 'AAP Steer Point MISSION', category = 'AAP'},
{down = iCommandPlane_AAP_SteerSw_Up, up=iCommandPlane_AAP_SteerSw_Up, name = 'AAP STEER Switch Up', category = 'AAP'},
{down = iCommandPlane_AAP_SteerSw_Down, up=iCommandPlane_AAP_SteerSw_Down, name = 'AAP STEER Switch Down', category = 'AAP'},

-- TACAN Control Panel
{down = iCommandPlane_TACAN_Mode_Off, 					name = 'TACAN Mode Select OFF', category = 'TACAN Control Panel'},
{down = iCommandPlane_TACAN_Mode_Rec, 					name = 'TACAN Mode Select REC', category = 'TACAN Control Panel'},
{down = iCommandPlane_TACAN_Mode_TR, 					name = 'TACAN Mode Select T R', category = 'TACAN Control Panel'},
{down = iCommandPlane_TACAN_Mode_AAREC, 				name = 'TACAN Mode Select A A REC', category = 'TACAN Control Panel'},
{down = iCommandPlane_TACAN_Mode_AATR, 					name = 'TACAN Mode Select A A T R', category = 'TACAN Control Panel'},
{pressed = iCommandPlane_TACAN_Volume_Decrease, 		name = 'TACAN Volume Decrease', category = 'TACAN Control Panel'},
{pressed = iCommandPlane_TACAN_Volume_Increase, 		name = 'TACAN Volume Increase', category = 'TACAN Control Panel'},
{pressed = iCommandPlane_TACAN_Chanel_Ones_Decrease, 	name = 'TACAN Chanel Ones Decrease', category = 'TACAN Control Panel'},
{pressed = iCommandPlane_TACAN_Chanel_Ones_Increase, 	name = 'TACAN Chanel Ones Increase', category = 'TACAN Control Panel'},
{pressed = iCommandPlane_TACAN_Chanel_Tens_Decrease, 	name = 'TACAN Chanel Tens Decrease', category = 'TACAN Control Panel'},
{pressed = iCommandPlane_TACAN_Chanel_Tens_Increase, 	name = 'TACAN Chanel Tens Increase', category = 'TACAN Control Panel'},
{down = iCommandPlane_TACAN_Chanel_XY_Mode, 			name = 'TACAN Mode X/Y Switch', category = 'TACAN Control Panel'},
{down = iCommandPlane_TACAN_Test, up=iCommandPlane_TACAN_Test,name = 'TACAN Test Button', category = 'TACAN Control Panel'},

-- ILS Control Panel
{down = iCommandPlane_ILS_Power, 						name = 'ILS Power Switch', category = 'ILS Control Panel'},
{pressed = iCommandPlane_ILS_MHz_Decrease, 				name = 'ILS Freq. MHz Decrease', category = 'ILS Control Panel'},
{pressed = iCommandPlane_ILS_MHz_Increase, 				name = 'ILS Freq. MHz Increase', category = 'ILS Control Panel'},
{pressed = iCommandPlane_ILS_KHz_Decrease, 				name = 'ILS Freq. KHz Decrease', category = 'ILS Control Panel'},
{pressed = iCommandPlane_ILS_KHz_Increase, 				name = 'ILS Freq. KHz Increase', category = 'ILS Control Panel'},
{pressed = iCommandPlane_ILS_Volume_Decrease, 			name = 'ILS Volume Decrease', category = 'ILS Control Panel'},
{pressed = iCommandPlane_ILS_Volume_Increase, 			name = 'ILS Volume Increase', category = 'ILS Control Panel'},

-- HARS Control Panel
{down = iCommandPlane_HARS_Mode, 						name = 'HARS Mode Selector SLAVE/DG', category = 'HARS Control Panel'},
{pressed = iCommandPlane_HARS_LAT_Correction_Decrease, 	name = 'HARS LAT Correction Decrease', category = 'HARS Control Panel'},
{pressed = iCommandPlane_HARS_LAT_Correction_Increase, 	name = 'HARS LAT Correction Increase', category = 'HARS Control Panel'},
{down = iCommandPlane_HARS_HemisphereSel, 				name = 'HARS Hemisphere Selector', category = 'HARS Control Panel'},
{down = iCommandPlane_HARS_MagneticVar_Min15, 			name = 'HARS Magnetic Variation -15', category = 'HARS Control Panel'},
{down = iCommandPlane_HARS_MagneticVar_Null, 			name = 'HARS Magnetic Variation 0', category = 'HARS Control Panel'},
{down = iCommandPlane_HARS_MagneticVar_Plus15, 			name = 'HARS Magnetic Variation +15', category = 'HARS Control Panel'},
{down = iCommandPlane_HARS_SyncButton,up=iCommandPlane_HARS_SyncButton, name = 'HARS SYNC Button', category = 'HARS Control Panel'},
{pressed = iCommandPlane_HARS_HDG_Decrease, 			name = 'HARS HDG Decrease', category = 'HARS Control Panel'},
{pressed = iCommandPlane_HARS_HDG_Increase, 			name = 'HARS HDG Increase', category = 'HARS Control Panel'},

-- Stall Warinig Control panel
{pressed = iCommandPlane_STALL_Vol_Decrease, 			name = 'Stall volume Decrease', category = 'Stall Warning Control Panel'},
{pressed = iCommandPlane_STALL_Vol_Increase, 			name = 'Stall volume Increase', category = 'Stall Warning Control Panel'},
{pressed = iCommandPlane_Peak_Vol_Decrease, 			name = 'Peak volume Decrease', category = 'Stall Warning Control Panel'},
{pressed = iCommandPlane_Peak_Vol_Increase, 			name = 'Peak volume Increase', category = 'Stall Warning Control Panel'},

--VHF FM Radio Control Panel
{pressed = iCommandPlane_VHF_FM_Volume_Dec, 			name = 'VHF FM Volume Decrease', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_Volume_Inc, 			name = 'VHF FM Volume Increase', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_Mode_EMERFM, 				name = 'VHF FM Mode EMER FM', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_Mode_EMERAM, 				name = 'VHF FM Mode EMER AM', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_Mode_MAN, 					name = 'VHF FM Mode MAN', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_Mode_PRE, 					name = 'VHF FM Mode PRE', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_FreqMode_OFF, 				name = 'VHF FM Frequency Mode OFF', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_FreqMode_TK, 				name = 'VHF FM Frequency Mode TK', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_FreqMode_DN, 				name = 'VHF FM Frequency Mode DN', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_Squelch, 				    name = 'VHF FM Squelch', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_Tone,up = iCommandPlane_VHF_FM_Tone, name = 'VHF FM Tone', category = 'VHF FM Radio Control Panel'},
{down = iCommandPlane_VHF_FM_Load,up=iCommandPlane_VHF_FM_Load, name = 'VHF FM Load', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_Preset_Dec, 			name = 'VHF FM Preset Channel Decrease', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_Preset_Inc, 			name = 'VHF FM Preset Channel Increase', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_10MHz_Dec, 				name = 'VHF FM 10Mhz Selector Decrease', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_10MHz_Inc, 				name = 'VHF FM 10Mhz Selector Increase', category = 'VHF FM Radio Control Panel'},

{pressed = iCommandPlane_VHF_FM_1MHz_Dec, 				name = 'VHF FM 1Mhz Selector Decrease', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_1MHz_Inc, 				name = 'VHF FM 1Mhz Selector Increase', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_01MHz_Dec, 				name = 'VHF FM 0.1Mhz Selector Decrease', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_01MHz_Inc, 				name = 'VHF FM 0.1Mhz Selector Increase', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_025MHz_Dec, 			name = 'VHF FM 0.025Mhz Selector Decrease', category = 'VHF FM Radio Control Panel'},
{pressed = iCommandPlane_VHF_FM_025MHz_Inc, 			name = 'VHF FM 0.025Mhz Selector Increase', category = 'VHF FM Radio Control Panel'},

--VHF AM Radio Control Panel
{pressed = iCommandPlane_VHF_AM_Volume_Dec, 			name = 'VHF AM Volume Decrease', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_Volume_Inc, 			name = 'VHF AM Volume Increase', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_Mode_EMERFM, 				name = 'VHF AM Mode EMER FM', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_Mode_EMERAM, 				name = 'VHF AM Mode EMER AM', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_Mode_MAN, 					name = 'VHF AM Mode MAN', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_Mode_PRE, 					name = 'VHF AM Mode PRE', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_FreqMode_OFF, 				name = 'VHF AM Frequency Mode OFF', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_FreqMode_TK, 				name = 'VHF AM Frequency Mode TK', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_FreqMode_DN, 				name = 'VHF AM Frequency Mode DN', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_Squelch, 				    name = 'VHF AM Squelch', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_Tone,up = iCommandPlane_VHF_AM_Tone, name = 'VHF AM Tone', category = 'VHF AM Radio Control Panel'},
{down = iCommandPlane_VHF_AM_Load,up=iCommandPlane_VHF_AM_Load, name = 'VHF AM Load', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_Preset_Dec, 			name = 'VHF AM Preset Channel Decrease', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_Preset_Inc, 			name = 'VHF AM Preset Channel Increase', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_10MHz_Dec, 				name = 'VHF AM 10Mhz Selector Decrease', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_10MHz_Inc, 				name = 'VHF AM 10Mhz Selector Increase', category = 'VHF AM Radio Control Panel'},

{pressed = iCommandPlane_VHF_AM_1MHz_Dec, 				name = 'VHF AM 1Mhz Selector Decrease', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_1MHz_Inc, 				name = 'VHF AM 1Mhz Selector Increase', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_01MHz_Dec, 				name = 'VHF AM 0.1Mhz Selector Decrease', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_01MHz_Inc, 				name = 'VHF AM 0.1Mhz Selector Increase', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_025MHz_Dec, 			name = 'VHF AM 0.025Mhz Selector Decrease', category = 'VHF AM Radio Control Panel'},
{pressed = iCommandPlane_VHF_AM_025MHz_Inc, 			name = 'VHF AM 0.025Mhz Selector Increase', category = 'VHF AM Radio Control Panel'},

--Environment System Panel
{down = iCommandPlane_Oxygen_Emergency, 				name = 'Oxygen Emergency Lever Emergenvy', category = 'Environment System Panel'},
{down = iCommandPlane_Oxygen_Normal, 					name = 'Oxygen Emergency Lever Normal', category = 'Environment System Panel'},
{down = iCommandPlane_Oxygen_TestMark, 					name = 'Oxygen Emergency Lever Test Mark', category = 'Environment System Panel'},
{down = iCommandPlane_Oxygen_Supply, 					name = 'Oxygen Supply Lever', category = 'Environment System Panel'},
{down = iCommandPlane_Oxygen_100Oxygen, 				name = 'Oxygen Dilution Lever', category = 'Environment System Panel'},
{down = iCommandPlane_Oxygen_Ind_Test,up=iCommandPlane_Oxygen_Ind_Test, name = 'Oxygen Indicator Test', category = 'Environment System Panel'},
{down = iCommandPitotAoAHeat, 						    name = 'Pitot Heater Switch', category = 'Environment System Panel'},
{down = iCommandPlane_Env_WindshieldDefogDeice, 		name = 'Wind shield Defog/Deice Switch', category = 'Environment System Panel'},
{down = iCommandPlane_Env_WindshieldRainRemove, 		name = 'Wind shield Rain Removal Switch', category = 'Environment System Panel'},
{down = iCommandPlane_Env_WindshieldCenter, 			name = 'Wind shield Rain Removal Switch Center', category = 'Environment System Panel'},
{down = iCommandPlane_Env_WindshieldWash, 				name = 'Wind shield Rain Removal Switch Wash', category = 'Environment System Panel'},
{pressed = iCommandPlane_Env_CanopyDefog_Dec, 			name = 'Canopy Defog Decrease', category = 'Environment System Panel'},
{pressed = iCommandPlane_Env_CanopyDefog_Inc, 			name = 'Canopy Defog Increase', category = 'Environment System Panel'},
{down = iCommandPlane_Env_BleddAir, 					name = 'Bleed Air Switch', category = 'Environment System Panel'},
{down = iCommandPlane_Env_TempPress_NORM, 				name = 'Temperature/Pressure Control NORM', category = 'Environment System Panel'},
{down = iCommandPlane_Env_TempPress_DUMP, 				name = 'Temperature/Pressure Control DUMP', category = 'Environment System Panel'},
{down = iCommandPlane_Env_TempPress_RAM, 				name = 'Temperature/Pressure Control RAM', category = 'Environment System Panel'},
{pressed = iCommandPlane_Env_FlowLevel_Decrease, 		name = 'Flow Level Decrease', category = 'Environment System Panel'},
{pressed = iCommandPlane_Env_FlowLevel_Increase, 		name = 'Flow Level Increase', category = 'Environment System Panel'},
{down = iCommandPlane_Env_MainAirSupply, 				name = 'Main Air Supply Switch', category = 'Environment System Panel'},
{down = iCommandPlane_Env_AirConditioner_AUTO, 			name = 'Air Conditioner Control AUTO', category = 'Environment System Panel'},
{down = iCommandPlane_Env_AirConditioner_HOT, up=iCommandPlane_Env_AirConditioner_HOT,	name = 'Air Conditioner Control HOT', category = 'Environment System Panel'},
{down = iCommandPlane_Env_AirConditioner_COLD, up= iCommandPlane_Env_AirConditioner_COLD, name = 'Air Conditioner Control COLD', category = 'Environment System Panel'},

{down = iCommandSeatArmHandle, 							name = 'Seat Arm Handle', category = 'Systems'},

},
}
end
